/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbqtLayoutLine.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:19 $
  Version:   $Revision: 1.4 $
=========================================================================*/


    

/**
 *  \file
 *  \brief
 */


#ifdef USE_QT

#include "bbqtLayoutLine.h"
#include "bbqtPackage.h"
#include "bbtkUtilities.h"

#include <QBoxLayout>

namespace bbqt
{
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(qt, LayoutLine);
  BBTK_BLACK_BOX_IMPLEMENTATION(LayoutLine,bbtk::QtBlackBox);
  
  void LayoutLine::bbUserSetDefaultValues()
  {
    bbSetInputOrientation("VERTICAL");
    bbSetInputWidget1(NULL);
    bbSetInputWidget2(NULL);
    bbSetInputWidget3(NULL);
    bbSetInputWidget4(NULL);
    bbSetInputWidget5(NULL);
    bbSetInputWidget6(NULL);
    bbSetInputWidget7(NULL);
    bbSetInputWidget8(NULL);
    bbSetInputWidget9(NULL);
  }
  
	void LayoutLine::bbUserInitializeProcessing()
	{
	}

	void LayoutLine::bbUserFinalizeProcessing()
	{
	}
	
	
  void LayoutLine::Process()
  {
  }
  

	
  void LayoutLine::CreateWidget(QWidget* parent)
  {
    QWidget *w = new QWidget(parent);
    QSizePolicy sizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    sizePolicy.setHorizontalStretch(1);
    sizePolicy.setVerticalStretch(1);
    sizePolicy.setHeightForWidth(parent->sizePolicy().hasHeightForWidth());
    w->setSizePolicy(sizePolicy);

    QBoxLayout::Direction dir;
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),
				    "0|H|HORIZONTAL")==true)  
      { dir = QBoxLayout::LeftToRight; }
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),
				    "1|V|VERTICAL")==true) 	
      {  dir = QBoxLayout::TopToBottom; }
    QBoxLayout* l = new QBoxLayout(dir);
    
    QWidget* cw;
    if ((cw=bbCreateWidgetOfInput("Widget1",w)) != 0) l->addWidget(cw);
    if ((cw=bbCreateWidgetOfInput("Widget2",w)) != 0) l->addWidget(cw);
    if ((cw=bbCreateWidgetOfInput("Widget3",w)) != 0) l->addWidget(cw);
    if ((cw=bbCreateWidgetOfInput("Widget4",w)) != 0) l->addWidget(cw);
    if ((cw=bbCreateWidgetOfInput("Widget5",w)) != 0) l->addWidget(cw);
    if ((cw=bbCreateWidgetOfInput("Widget6",w)) != 0) l->addWidget(cw);
    if ((cw=bbCreateWidgetOfInput("Widget7",w)) != 0) l->addWidget(cw);
    if ((cw=bbCreateWidgetOfInput("Widget8",w)) != 0) l->addWidget(cw);
    if ((cw=bbCreateWidgetOfInput("Widget9",w)) != 0) l->addWidget(cw);
    
 
    w->setLayout(l);

    
    bbSetOutputWidget( w );
  }
  
  // This callback is necessary to get actual processing of the view 
  // when window is shown
  void  LayoutLine::OnShowWidget()
  {
    /*
    bbUserOnShowWidget("Widget1");
    bbUserOnShowWidget("Widget2");
    bbUserOnShowWidget("Widget3");
    bbUserOnShowWidget("Widget4");
    bbUserOnShowWidget("Widget5");
    bbUserOnShowWidget("Widget6");
    bbUserOnShowWidget("Widget7");
    bbUserOnShowWidget("Widget8");
    bbUserOnShowWidget("Widget9");
    */
  }

}//namespace bbqt

#endif // USE_QT

