/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbqtLayoutLine.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:19 $
  Version:   $Revision: 1.3 $
=========================================================================*/


/**
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
 */
/**
 * \file 
 * \brief Pattern for the definition of a new type of Node (header)
 */
/**
 * \class bbtk::NodePatern 
 * \brief Pattern for the definition of a new type of Node 
 */


#ifdef USE_QT


#ifndef __bbqtQLayoutLine_h__
#define __bbqtQLayoutLine_h__

#include "bbtkQtBlackBox.h"
#include "bbqt_EXPORT.h"


namespace bbqt
{
  

  
  //===========================================================
  class bbqt_EXPORT LayoutLine : public bbtk::QtBlackBox
  {
    
    BBTK_BLACK_BOX_INTERFACE(LayoutLine,bbtk::QtBlackBox);
    BBTK_DECLARE_INPUT(Widget1,QWidget*);
    BBTK_DECLARE_INPUT(Widget2,QWidget*);
    BBTK_DECLARE_INPUT(Widget3,QWidget*);
    BBTK_DECLARE_INPUT(Widget4,QWidget*);
    BBTK_DECLARE_INPUT(Widget5,QWidget*);
    BBTK_DECLARE_INPUT(Widget6,QWidget*);
    BBTK_DECLARE_INPUT(Widget7,QWidget*);
    BBTK_DECLARE_INPUT(Widget8,QWidget*);
    BBTK_DECLARE_INPUT(Widget9,QWidget*);
    BBTK_DECLARE_INPUT(Orientation,std::string);
    BBTK_PROCESS(Process);
    BBTK_CREATE_WIDGET(CreateWidget);
    BBTK_ON_SHOW_WIDGET(OnShowWidget);
 
    void Process();
    void CreateWidget(QWidget*);
    void OnShowWidget();
    
  protected:
    //	void TryInsertWindow(QWidget *parent, QWidget *w,qtBoxSizer *sizer);
    //
  };
  //===========================================================
  
 
  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(LayoutLine,bbtk::QtBlackBox);
  BBTK_NAME("QLayoutLine");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Linear layout widget (QBoxLayout)");
  // Already inserted for any QtBlackBox  BBTK_CATEGORY("widget");  
  BBTK_INPUT(LayoutLine,Widget1,"widget 1",QWidget*,"");
  BBTK_INPUT(LayoutLine,Widget2,"widget 2",QWidget*,"");
  BBTK_INPUT(LayoutLine,Widget3,"widget 3",QWidget*,"");
  BBTK_INPUT(LayoutLine,Widget4,"widget 4",QWidget*,"");
  BBTK_INPUT(LayoutLine,Widget5,"widget 5",QWidget*,"");
  BBTK_INPUT(LayoutLine,Widget6,"widget 6",QWidget*,"");
  BBTK_INPUT(LayoutLine,Widget7,"widget 7",QWidget*,"");
  BBTK_INPUT(LayoutLine,Widget8,"widget 8",QWidget*,"");
  BBTK_INPUT(LayoutLine,Widget9,"widget 9",QWidget*,"");
  BBTK_INPUT(LayoutLine,Orientation,"Orientation (default V), 0=H=HORIZONTAL , 1=V=VERTICAL",std::string,"");
  BBTK_END_DESCRIBE_BLACK_BOX(LayoutLine);
  //=================================================================
  
  
  
}



//namespace bbtk
#endif  //__bbtkQtLayoutLine_h__

#endif //USE_QTWIDGETS
