/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbqtLayoutSplit.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:19 $
  Version:   $Revision: 1.3 $
=========================================================================*/



/**
 */
/**
 * \file 
 * \brief Widget which splits a window into two parts 
 */
/**
 * \class bbqt::LayoutSplit
 * \brief Widget which splits a window into two parts 
 */


#ifdef USE_QT


#ifndef __bbqtQLayoutSplit_h__
#define __bbqtQLayoutSplit_h__

#include "bbtkQtBlackBox.h"
#include "bbqt_EXPORT.h"

namespace bbqt
{
  
  
  
  
  //=================================================================
  class bbqt_EXPORT LayoutSplit : public bbtk::QtBlackBox
  {
    
    BBTK_BLACK_BOX_INTERFACE(LayoutSplit,bbtk::QtBlackBox);
    BBTK_DECLARE_INPUT(Widget1,QWidget*);
    BBTK_DECLARE_INPUT(Widget2,QWidget*);
    BBTK_DECLARE_INPUT(Widget3,QWidget*);
    BBTK_DECLARE_INPUT(Widget4,QWidget*);
    BBTK_DECLARE_INPUT(Widget5,QWidget*);
    BBTK_DECLARE_INPUT(Widget6,QWidget*);
    BBTK_DECLARE_INPUT(Widget7,QWidget*);
    BBTK_DECLARE_INPUT(Widget8,QWidget*);
    BBTK_DECLARE_INPUT(Widget9,QWidget*);

    BBTK_DECLARE_INPUT(Weight1,int);
    BBTK_DECLARE_INPUT(Weight2,int);
    BBTK_DECLARE_INPUT(Weight3,int);
    BBTK_DECLARE_INPUT(Weight4,int);
    BBTK_DECLARE_INPUT(Weight5,int);
    BBTK_DECLARE_INPUT(Weight6,int);
    BBTK_DECLARE_INPUT(Weight7,int);
    BBTK_DECLARE_INPUT(Weight8,int);
    BBTK_DECLARE_INPUT(Weight9,int);

    BBTK_DECLARE_INPUT(Orientation,std::string);
    //    BBTK_DECLARE_INPUT(Proportion,int);
    BBTK_PROCESS(Process);
    BBTK_CREATE_WIDGET(CreateWidget);
    BBTK_ON_SHOW_WIDGET(OnShowWidget);
    
    void Process();
    void CreateWidget(QWidget*);
    void OnShowWidget();

  protected:

  };
  //=================================================================
  
 
  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(LayoutSplit,bbtk::QtBlackBox);
  BBTK_NAME("QLayoutSplit");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  BBTK_DESCRIPTION("Widget which splits a window in two resizable parts (QSplitter)");
  BBTK_INPUT(LayoutSplit,Widget1,"First widget to layout (upper or left most)",QWidget*,"");
  BBTK_INPUT(LayoutSplit,Widget2,"Second widget",QWidget*,"");
  BBTK_INPUT(LayoutSplit,Widget3,"Third widget",QWidget*,"");
  BBTK_INPUT(LayoutSplit,Widget4,"Fourth widget",QWidget*,"");
  BBTK_INPUT(LayoutSplit,Widget5,"Fifth widget",QWidget*,"");
  BBTK_INPUT(LayoutSplit,Widget6,"Sixth widget",QWidget*,"");
  BBTK_INPUT(LayoutSplit,Widget7,"Seventh widget",QWidget*,"");
  BBTK_INPUT(LayoutSplit,Widget8,"Eighth widget",QWidget*,"");
  BBTK_INPUT(LayoutSplit,Widget9,"Nineth widget",QWidget*,"");

  BBTK_INPUT(LayoutSplit,Weight1,"Weight of the widget 1",int,"");
  BBTK_INPUT(LayoutSplit,Weight2,"Weight of the widget 2",int,"");
  BBTK_INPUT(LayoutSplit,Weight3,"Weight of the widget 3",int,"");
  BBTK_INPUT(LayoutSplit,Weight4,"Weight of the widget 4",int,"");
  BBTK_INPUT(LayoutSplit,Weight5,"Weight of the widget 5",int,"");
  BBTK_INPUT(LayoutSplit,Weight6,"Weight of the widget 6",int,"");
  BBTK_INPUT(LayoutSplit,Weight7,"Weight of the widget 7",int,"");
  BBTK_INPUT(LayoutSplit,Weight8,"Weight of the widget 8",int,"");
  BBTK_INPUT(LayoutSplit,Weight9,"Weight of the widget 9",int,"");


  BBTK_INPUT(LayoutSplit,Orientation,"Orientation (default H), 0=H=HORIZONTAL , 1=V=VERTICAL",std::string,"");
  //  BBTK_INPUT(LayoutSplit,Proportion,"Proportion (in percent) of the first children in the window",int,"");
  BBTK_END_DESCRIBE_BLACK_BOX(LayoutSplit);
  //=================================================================
}

//namespace bbqt
#endif  //__bbqtQtLayoutSplit_h__

#endif //USE_QT
