/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifdef USE_QT

#ifndef __bbqtQOutputText_h_INCLUDED__
#define __bbqtQOutputText_h_INCLUDED__
#include "bbqt_EXPORT.h"
#include "bbtkQtBlackBox.h"

namespace bbqt
{

class bbqt_EXPORT QOutputText
 : 
   public bbtk::QtBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(QOutputText,bbtk::QtBlackBox);

  BBTK_DECLARE_INPUT(Title,std::string);
  BBTK_DECLARE_INPUT(In,std::string);
  BBTK_PROCESS(Process);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(QWidget*);
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(QOutputText,bbtk::QtBlackBox);
BBTK_NAME("QOutputText");
BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
BBTK_DESCRIPTION("OutputText");
BBTK_CATEGORY("");
BBTK_INPUT(QOutputText,Title,"Title prepended to the text",std::string,"");
BBTK_INPUT(QOutputText,In,"Text",std::string,"");
BBTK_END_DESCRIBE_BLACK_BOX(QOutputText);
}
// EO namespace bbqt

#endif // __bbqtQOutputText_h_INCLUDED__
#endif // USE_QT

