/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbqtSlider.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:19 $
  Version:   $Revision: 1.3 $
=========================================================================*/


/**
 * \file 
 * \brief Short description in one line
 *
 * Long 
 * description
 *  
 */

#ifdef USE_QT

#include "bbqtSlider.h"
#include "bbqtPackage.h"
#include "bbtkUtilities.h"

namespace bbqt
{

 

  //--------------------------------------------------------------------------
  //-------------------------------------------------------------------------
  // QtBlackBox implementation
  //--------------------------------------------------------------------------
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
  BBTK_BLACK_BOX_IMPLEMENTATION(Slider,bbtk::QtBlackBox);
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(qt,Slider);
  
  //--------------------------------------------------------------------------
  void Slider::bbUserSetDefaultValues() 
  { 
    bbSetInputIn(0);
    bbSetInputMin(0);
    bbSetInputMax(500);
    bbSetOutputOut(0);
    bbSetInputOrientation("HORIZONTAL");
    bbSetInputChangeResolution(false);
    bbSetInputLabel(true);
    bbSetInputReactiveOnTrack(false);    
  }
  //--------------------------------------------------------------------------
  
	
	//--------------------------------------------------------------------------
	void Slider::bbUserInitializeProcessing()
	{
	}
	//--------------------------------------------------------------------------

	
	//--------------------------------------------------------------------------
	void Slider::bbUserFinalizeProcessing()
	{
	}
	//--------------------------------------------------------------------------
	
	
	
  //--------------------------------------------------------------------------
  void Slider::Process() 
  {
    bbtkDebugMessage("process",3,
		     "Slider "<<bbGetName()<<" input="
		     <<bbGetInputIn()<<std::endl);
   
    bbSetOutputOut( bbGetInputIn() );
    if (bbGetOutputWidget()!=0)
      {
	((QSlider*)bbGetOutputWidget())->setValue(bbGetInputIn());
      }
  }
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
  void Slider::CreateWidget(QWidget* parent)
  {

     Qt::Orientation orientation;
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),"0|H|HORIZONTAL")
	==true)  
      { orientation = Qt::Horizontal; }
    if (bbtk::Utilities::loosematch(bbGetInputOrientation(),"1|V|VERTICAL")
	==true)    
      { orientation = Qt::Vertical ; }
    
    
    //    std::cout << "bbGetQtParent = "<<bbGetQtParent()<<std::endl;
    QSlider *w =  new QSlider(parent);
    w->setOrientation(orientation);
    w->setMinimum( bbGetInputMin() );
    w->setMaximum( bbGetInputMax() );
    w->setSliderPosition ( bbGetInputIn() );
    
    if (bbGetInputReactiveOnTrack()) 
      w->setTracking(true);
    else 
      w->setTracking(false);

    connect(w,SIGNAL(valueChanged(int)),this,SLOT(OnValueChanged(int)));


    bbSetOutputWidget( w );
  }
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
  void Slider::OnValueChanged(int v)
  {
    //   std::cout << "OnValueChanged "<<v<<std::endl;
    bbSetOutputOut( v ); 
    bbSetInputIn( v );
    // and signal that the output has changed
    bbSignalOutputModification(std::string("Out"));

  }
  //--------------------------------------------------------------------------


} //namespace bbqt

#endif // USE_QT


