/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbqtSlider.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:19 $
  Version:   $Revision: 1.3 $
=========================================================================*/


/**
 * \file 
 * \brief Short description in one line
 * 
 * Long description which 
 * can span multiple lines
*/

/**
 * \class bbqt::Slider
 * \brief 

 * \class bbqt::SliderWidget
 * \brief 
 */

#ifdef USE_QT

// Prevents multiple inclusions : use symbols of the form
// __FILENAME_INCLUDED__ 
// where FILENAME must be replaced by the actual file name
#ifndef __bbqtSlider_h_INCLUDED__
#define __bbqtSlider_h_INCLUDED__

// Include qtBlackBox definition
#include "bbtkQtBlackBox.h"

#include "bbqt_EXPORT.h"

#include <QSlider>

// Namespace of the package "qt" is "bbqt" 
// Namespace associated to packages should be of the form :
// bbPACKAGENAME
namespace bbqt
{
  
   

  
  //------------------------------------------------------------------------
  // The black box
  class bbqt_EXPORT Slider : public QObject,
			     public bbtk::QtBlackBox
  {
    Q_OBJECT
    
    BBTK_BLACK_BOX_INTERFACE(Slider,bbtk::QtBlackBox);
    BBTK_DECLARE_INPUT(In,int);
    BBTK_DECLARE_INPUT(Min,int);
    BBTK_DECLARE_INPUT(Max,int);
    BBTK_DECLARE_INPUT(Label,bool);
    BBTK_DECLARE_INPUT(Title,std::string); 
    BBTK_DECLARE_INPUT(Orientation,std::string);
    BBTK_DECLARE_INPUT(ChangeResolution,bool);
    BBTK_DECLARE_INPUT(ReactiveOnTrack,bool);    
    BBTK_DECLARE_OUTPUT(Out,int);
    BBTK_PROCESS(Process);
    BBTK_CREATE_WIDGET(CreateWidget);
    void Process();
    void CreateWidget(QWidget*);

  public slots:
    void OnValueChanged(int);


  protected:

    //   QSlider* mSlider;
  };
  //=================================================================
 
  //=================================================================
  // the black box description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(Slider,bbtk::QtBlackBox);
  BBTK_NAME("QSlider");
  BBTK_AUTHOR("laurent.guigues@creatis.insa-lyon.fr");
  // Already inserted for any QtBlackBox  BBTK_CATEGORY("widget");
  BBTK_DESCRIPTION("Slider widget (QSlider)");
  BBTK_INPUT(Slider,In,"Initial position of the slider (default 0)",int,"");
  BBTK_INPUT(Slider,Min,"Minimum value of the slider (default 0)",int,"");
  BBTK_INPUT(Slider,Max,"Maximum value of the slider (default 500)",int,"");
  BBTK_INPUT(Slider,Label,"Show slider labels ? (default FALSE) ",bool,"");
  BBTK_INPUT(Slider,Title,"Title shown above the slider (default '') ", std::string,"");
  BBTK_INPUT(Slider,Orientation, "Orientation : (default H)  0=H=HORIZONTAL, 1=V=VERTICAL ",std::string,"");
  BBTK_INPUT(Slider,ChangeResolution, "Can the user change the resolution of the slider ? (default FALSE) ",bool,"");
  BBTK_INPUT(Slider,ReactiveOnTrack, "Slider sends info when track moves (default : FALSE)",bool,"");  
  BBTK_OUTPUT(Slider,Out,"Current position of the slider",int,"");
  BBTK_END_DESCRIBE_BLACK_BOX(Slider);
  //=================================================================
  


} //namespace bbqt

#endif  //__bbtkqtSlider_h_INCLUDED__

#endif //USE_QT
