/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdASCII.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.8 $
=========================================================================*/

#include "bbstdASCII.h"
#include "bbstdPackage.h"
namespace bbstd
{
  
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(std,ASCII);
  BBTK_BLACK_BOX_IMPLEMENTATION(ASCII,bbtk::AtomicBlackBox);
  void ASCII::Process()
  {
    int asciiValue;
    char strTmp[10];
    std::string result("");
    if (bbGetInputIn()!=""){
      
      if (bbGetInputType()==0){
	std::string commandstr(bbGetInputIn());
	bool ok=true;
	int pos1=0,pos2;
	pos2 = commandstr.find(" ",pos1);
	std::string ccommand;
	while (ok==true)
	  {
	    if (pos2==-1)	
	      {
		ok=false;
		ccommand=commandstr.substr(pos1,commandstr.length()-pos1 );
	      } 	else  {
	      ccommand=commandstr.substr(pos1,pos2-pos1);
	    }
	    asciiValue = atoi( ccommand.c_str() );
	    sprintf(strTmp,"%c",asciiValue);
	    result += strTmp;
	    
	    pos1=pos2+1;
	    pos2 = commandstr.find(" ",pos2+1);
	  } // while
      } // if Type 0
      
      if (bbGetInputType()==1){
	int i,size=bbGetInputIn().size();
	for (i=0;i<size;i++){
	  asciiValue = (int)bbGetInputIn()[i];
	  sprintf(strTmp,"%d",asciiValue);
	  result +=strTmp;
	  if (i!=size-1) {
	    result +=" ";
	  } // i!=size-1
	} // for
      } // Type 1
    }
    bbSetOutputOut( result );  
  }
  
  void ASCII::bbUserSetDefaultValues()
  {
    bbSetInputIn("");
    bbSetInputType(0);
  }
   void ASCII::bbUserInitializeProcessing() 
  { 
  }
  void ASCII::bbUserFinalizeProcessing() 
  {
  } 
 
}
// EO namespace bbstd


