/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdCastVector.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.5 $
=========================================================================*/

#include "bbstdCastVector.h"
#include "bbstdPackage.h"

namespace bbstd 
{
  
  //====================================================================
  BBTK_BLACK_BOX_TEMPLATE2_IMPLEMENTATION(CastVector,
					  bbtk::AtomicBlackBox);
  //====================================================================
  
  //====================================================================
  // Add the instanciated adaptors to the package
  
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,double,int8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int8_t,double);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,double,uint8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint8_t,double);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,double,int16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int16_t,double);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,double,uint16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint16_t,double);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,double,int32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int32_t,double);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,double,uint32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint32_t,double);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,double,float);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,float,double);
  
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,bool,double);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,double, bool); 
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,bool,float);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,float, bool);    
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,bool,uint32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint32_t, bool);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,bool,int32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int32_t, bool);  
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,bool,uint16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint16_t, bool);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,bool,int16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int16_t, bool);  
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,bool,uint8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint8_t, bool);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,bool,int8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int8_t, bool);   
       
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,float,int8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int8_t,float);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,float,uint8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint8_t,float);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,float,int16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int16_t,float);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,float,uint16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint16_t,float);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,float,int32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int32_t,float);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,float,uint32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint32_t,float);
  
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int32_t,int8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int8_t,int32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int32_t,uint8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint8_t,int32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int32_t,int16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int16_t,int32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int32_t,uint16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint16_t,int32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int32_t,uint32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint32_t,int32_t);
  
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint32_t,int8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int8_t,uint32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint32_t,uint8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint8_t,uint32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint32_t,int16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int16_t,uint32_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint32_t,uint16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint16_t,uint32_t);
  
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint16_t,int8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int8_t,uint16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint16_t,uint8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint8_t,uint16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint16_t,int16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int16_t,uint16_t);
  
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int16_t,int8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int8_t,int16_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int16_t,uint8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint8_t,int16_t);
  
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,uint8_t,int8_t);
  BBTK_ADD_TEMPLATE2_BLACK_BOX_TO_PACKAGE(std,CastVector,int8_t,uint8_t);
  

  //====================================================================
  

} // namespace bbstd
