/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbstdCreateArithmeticSuiteVector_h_INCLUDED__
#define __bbstdCreateArithmeticSuiteVector_h_INCLUDED__
#include "bbstd_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

namespace bbstd
{

class bbstd_EXPORT CreateArithmeticSuiteVector
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(CreateArithmeticSuiteVector,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(FirstValue,double);
  BBTK_DECLARE_INPUT(Delta,double);
  BBTK_DECLARE_INPUT(Size,int);
  BBTK_DECLARE_OUTPUT(ArithmeticSuiteVector,std::vector<double>);
  BBTK_PROCESS(Process);
  void Process();
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(CreateArithmeticSuiteVector,bbtk::AtomicBlackBox);
BBTK_NAME("CreateArithmeticSuiteVector");
BBTK_AUTHOR("Claire Mouton");
BBTK_DESCRIPTION("Creates a vector with the values of an arithmetic suite, given the first value, the difference between two consecutive elements (delta) and its size.");
BBTK_CATEGORY("std");
BBTK_INPUT(CreateArithmeticSuiteVector,FirstValue,"The first value of the vector.",double,"");
BBTK_INPUT(CreateArithmeticSuiteVector,Delta,"The difference between two consecutive elements (Put 0 to get a constatn vector).",double,"");
BBTK_INPUT(CreateArithmeticSuiteVector,Size,"Size of the vector to create.",int,"");
BBTK_OUTPUT(CreateArithmeticSuiteVector,ArithmeticSuiteVector,"The created vector.",std::vector<double>,"");
BBTK_END_DESCRIBE_BLACK_BOX(CreateArithmeticSuiteVector);
}
// EO namespace bbstd

#endif // __bbstdCreateArithmeticSuiteVector_h_INCLUDED__

