/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdExecBbiCommand.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.12 $
=========================================================================*/



#include "bbstdExecBbiCommand.h"
#include "bbstdPackage.h"
#include "bbtkInterpreter.h"
#include "bbtkExecuter.h"

namespace bbstd
{

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(std,ExecBbiCommand);
  BBTK_BLACK_BOX_IMPLEMENTATION(ExecBbiCommand,bbtk::AtomicBlackBox);

  void ExecBbiCommand::bbUserSetDefaultValues() 
  { 
    bbSetInputIn("help");
  }
  void ExecBbiCommand::bbUserInitializeProcessing() 
  { 
  }
  void ExecBbiCommand::bbUserFinalizeProcessing() 
  {
  }
  
  void ExecBbiCommand::DoProcess()
    {

      // Look for the interpreter
      bbtk::Interpreter::Pointer I;
	  bool delete_inter = false;
	  if (bbGetParent() != 0)
	  {
	  bbtk::Factory::Pointer f
	  	= ((bbtk::ComplexBlackBoxDescriptor*)bbGetParent()
		  ->bbGetDescriptor().get())->GetFactory();
	  if ((f != 0)&&
	      (f->GetExecuter()))
	    {
	      I = f->GetExecuter()->GetInterpreter();
	    }
	  }
      if (I==0)
	  {
	  //	  bbtkError("ExecBbiCommand::DoProcess() : could not find interpreter");
	  I = bbtk::Interpreter::New();
	  delete_inter = true;
	  }

      unsigned int i;

      bool ok=true;
      int pos1=0,pos2;
      pos2 = bbGetInputIn().find(";",pos1);
      std::string ccommand;
      while (ok==true)
	    {
	  if (pos2==-1) 
	   {
	    ok=false;
	    ccommand=bbGetInputIn().substr(pos1,bbGetInputIn().length()-pos1 );
	   } else {
	    ccommand=bbGetInputIn().substr(pos1,pos2-pos1);
	  }
	  for ( i=0 ; i < ccommand.length() ; i++)
	  {
	    if (ccommand[i]==39)
	    {
		  ccommand[i]=34;
        }
     }

	  I->InterpretLine( ccommand );
	  pos1=pos2+1;
	  pos2 = bbGetInputIn().find(";",pos2+1);

	}
      
//      if (delete_inter) delete I;

   /*  Grrr  not works in windows
	char * pch;
  	pch = strtok (bbGetInputIn(),";");
	while (pch != NULL)
	{
		std::string ccommand(pch);
		printf("EED  ExecBbiCommand::DoProcess 1.1  %s\n",ccommand.c_str());
		for ( i=0 ; i < ccommand.length() ; i++)
		{
			if (ccommand[i]==39)
			{
				ccommand[i]=34;
			}
		}

		printf("EED  ExecBbiCommand::DoProcess 2  %s\n",ccommand.c_str());
		bbtk::Interpreter::mGlobalInterpreter->InterpretLine( ccommand );
    	pch = strtok (NULL, ";");
  	}
  */
  }
} // EO namespace bbstd


