/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdExecSystemCommand.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.12 $
=========================================================================*/

#include "bbstdExecSystemCommand.h"
#include "bbstdPackage.h"
#include "bbtkInterpreter.h"

namespace bbstd
{

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(std,ExecSystemCommand);
  BBTK_BLACK_BOX_IMPLEMENTATION(ExecSystemCommand,bbtk::AtomicBlackBox);

  void ExecSystemCommand::bbUserSetDefaultValues() 
  { 
    bbSetInputIn("help");
  }
  void ExecSystemCommand::bbUserInitializeProcessing() 
  { 
  }
  void ExecSystemCommand::bbUserFinalizeProcessing() 
  {
  }
  
  void ExecSystemCommand::DoProcess()
  {
    bool ok=true;
    int pos1=0,pos2;
    pos2 = bbGetInputIn().find(";",pos1);
    std::string ccommand;
    int result = 0;
    while (ok)
    {
	  if (pos2==-1) 
	  {
	    ok=false;
	    ccommand=bbGetInputIn().substr(pos1,bbGetInputIn().length()-pos1 );
	  } else {
	    ccommand=bbGetInputIn().substr(pos1,pos2-pos1);
	  }
	  for (unsigned int i=0 ; i < ccommand.length() ; i++)
	  {
	    if (ccommand[i]==39)
	    {
		  ccommand[i]=34;
        }
      }
      #if defined(_WIN32)
	    ccommand="start /b "+ccommand;
      #endif // defined(_WIN32)	
	  std::cout << "*** Executing system command : '"<<ccommand<<"'"<<std::endl;
	  
	  result = system ( ccommand.c_str() );
	  
	  //std::cout << "DFGO - ExecSystemCommand::DoProcess result=" << result << std::endl;
	  
	  //DFGO - if return code is different than 0 result is equal 1
	  
	  if(result)
	  {
        result = 1;
	    ok = false;
	  }
	  pos1=pos2+1;
	  pos2 = bbGetInputIn().find(";",pos2+1);
   }
   
   bbSetOutputReturn(result);
   //std::cout << "DFGO - ExecSystemCommand::DoProcess result=" << result << std::endl;
   
    /* Grrr  not works in windows
      int i;
      char *str = (char*)bbGetInputIn().c_str();
      char * pch;
      pch = strtok (str,";");
      while (pch != NULL)
      {
      std::string ccommand(pch);
      for ( i=0 ; i < ccommand.length() ; i++)
      {
      if (ccommand[i]==39)
      {
      ccommand[i]=34;
      }
      }
      
      // bbtk::Interpreter::mGlobalInterpreter->InterpretLine( ccommand );
      system ( ccommand.c_str() );
      pch = strtok (NULL, ";");
      }
      //      bbSetOutputOut( bbGetInputIn() );
  */
  }
} // EO namespace bbstd


