/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifndef __bbstdFilesFromDirectory_h_INCLUDED__
#define __bbstdFilesFromDirectory_h_INCLUDED__
#include "bbtkAtomicBlackBox.h"
#include "iostream"
#include "bbstd_EXPORT.h"

namespace bbstd
{

  class bbstd_EXPORT FilesFromDirectory
    : 
    public bbtk::AtomicBlackBox
  {
    BBTK_BLACK_BOX_INTERFACE(FilesFromDirectory,bbtk::AtomicBlackBox);
    BBTK_DECLARE_INPUT(In,std::string);
    BBTK_DECLARE_INPUT(Recursive,bool);  
    BBTK_DECLARE_OUTPUT(Out,std::vector<std::string>);
    BBTK_PROCESS(Process);
    void Process();
    
  private :
    std::string NormalizePath(std::string const &pathname);
    int Explore(std::string const &dirpath, bool recursive);
    
    /// List of file names
    std::vector<std::string> Filenames;
    /// name of the root directory to explore
    std::string DirName;
  };
  
  //=================================================================
  // BlackBox description
  BBTK_BEGIN_DESCRIBE_BLACK_BOX(FilesFromDirectory,bbtk::AtomicBlackBox);
  BBTK_NAME("FilesFromDirectory");
  BBTK_AUTHOR("jpr@creatis.univ-lyon1.fr");
  BBTK_DESCRIPTION("returns the fullPathNames of the files in a Directory");
  BBTK_CATEGORY("");
  BBTK_INPUT(FilesFromDirectory,In,"Directory Name",std::string,"");
  BBTK_INPUT(FilesFromDirectory,Recursive,"Recursive directory exploration",bool,"");
  
  BBTK_OUTPUT(FilesFromDirectory,Out,"FullPathNames of the files",std::vector<std::string>,"");
  BBTK_END_DESCRIBE_BLACK_BOX(FilesFromDirectory);

}
// EO namespace bbstd

#endif // __bbstdFilesFromDirectory_h_INCLUDED__

