/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "bbstdGetIntervalNumberFromIntervalList.h"
#include "bbstdPackage.h"

namespace bbstd
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(std,GetIntervalNumberFromIntervalList)
BBTK_BLACK_BOX_IMPLEMENTATION(GetIntervalNumberFromIntervalList,bbtk::AtomicBlackBox);

void GetIntervalNumberFromIntervalList::Process()
{
  // Sets the default value, in the case of an inexisting value in the intervals. 
  bbSetOutputIntervalNumber(bbGetInputErrorValue());
  bool found = false;

 // Looks for the first interval containing the input value.
  for (int i = 0; i < (int) bbGetInputIntervalList().size() - 1; i++)
    {
      if (found == false)
	{
	  if (bbGetInputValue() >=  bbGetInputIntervalList()[i] && bbGetInputValue() < bbGetInputIntervalList()[i+1]) 
	    {
	      bbSetOutputIntervalNumber(i);
	      found = true;
	    }
	}
    }

}

void GetIntervalNumberFromIntervalList::bbUserSetDefaultValues()
{
  bbSetInputErrorValue(-1.0);
}

void GetIntervalNumberFromIntervalList::bbUserInitializeProcessing()
{
 
}

void GetIntervalNumberFromIntervalList::bbUserFinalizeProcessing()
{
  
}
}
// EO namespace bbstd


