/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdGetVectorElement.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.4 $
=========================================================================*/


#include "bbstdGetVectorElement.h"
#include "bbstdPackage.h"


namespace bbstd
{
  //====================================================================
  BBTK_BLACK_BOX_TEMPLATE_IMPLEMENTATION(GetVectorElement,
					 bbtk::AtomicBlackBox);
  //====================================================================

//====================================================================
// Add the specialized boxes to the package

BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,GetVectorElement,int8_t);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,GetVectorElement,uint8_t);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,GetVectorElement,int16_t);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,GetVectorElement,uint16_t);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,GetVectorElement,int32_t);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,GetVectorElement,uint32_t);
///\todo : diff between uint32_t and long?
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,GetVectorElement,long);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,GetVectorElement,float);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,GetVectorElement,double);
typedef std::string string;
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,GetVectorElement,string);
//====================================================================

} // namespace bbstd
