/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdMagicBox.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.9 $
=========================================================================*/

#include "bbstdMagicBox.h"
#include "bbstdPackage.h"
#include "bbtkBlackBoxOutputConnector.h"
using namespace bbtk;

namespace bbstd
{

	void MagicBox::bbComputePostProcessStatus()
	{
	AtomicBlackBox::bbComputePostProcessStatus();

	if (bbGetInputActive()==false)
	{
		// Update the output statuses
		IOStatus new_output_status = UPTODATE;
		OutputConnectorMapType::iterator o;
		for ( o = bbGetOutputConnectorMap().begin(); o!= bbGetOutputConnectorMap().end(); ++o) 
		{
			o->second->SetStatus(new_output_status);
		} // for o
	} // if

  }


  void MagicBox::bbUserSetDefaultValues()
  {
	bbSetInputActive(true);
  }

  void MagicBox::bbUserInitializeProcessing() 
  { 
  }

  void  MagicBox::bbUserFinalizeProcessing() 
  {
  }

  void MagicBox::DoProcess()
  { 
	if (bbGetInputActive()==true)
	{
		bbSetOutputOut( bbGetInputIn() );
	} // Active
  }

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(std,MagicBox);
  BBTK_BLACK_BOX_IMPLEMENTATION(MagicBox,bbtk::AtomicBlackBox);
  
}
// EO namespace bbstd
