/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "bbstdMixingVectors.h"
#include "bbstdPackage.h"
namespace bbstd
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(std,MixingVectors)
BBTK_BLACK_BOX_IMPLEMENTATION(MixingVectors,bbtk::AtomicBlackBox);

void MixingVectors::Process()
{
// THE MAIN PROCESSING METHOD BODY
   int size1 = bbGetInputIn1().size();
   int size2 = bbGetInputIn2().size();
   int size3 = bbGetInputIn3().size();
   int size4 = bbGetInputIn4().size();
   int size5 = bbGetInputIn5().size();
   int size6 = bbGetInputIn6().size();
   int size7 = bbGetInputIn7().size();
   int size8 = bbGetInputIn8().size();
   int size9 = bbGetInputIn9().size();
   int size10 = bbGetInputIn10().size();
   std::vector<double> outputVector;

   for (int i = 0; i < size1; i++)
     {
       outputVector.push_back( bbGetInputIn1()[i] );
       if (i < size2)
	  outputVector.push_back( bbGetInputIn2()[i] );
        if (i < size3)
	  outputVector.push_back( bbGetInputIn3()[i] );
        if (i < size4)
	  outputVector.push_back( bbGetInputIn4()[i] );
        if (i < size5)
	  outputVector.push_back( bbGetInputIn5()[i] );
        if (i < size6)
	  outputVector.push_back( bbGetInputIn6()[i] );
        if (i < size7)
	  outputVector.push_back( bbGetInputIn7()[i] );
        if (i < size8)
	  outputVector.push_back( bbGetInputIn8()[i] );
        if (i < size9)
	  outputVector.push_back( bbGetInputIn9()[i] );
        if (i < size10)
	  outputVector.push_back( bbGetInputIn10()[i] );
     }

   bbSetOutputOut(outputVector);  
}

void MixingVectors::bbUserSetDefaultValues()
{
   // THE DEFAULT INPUT/OUTPUT VALUES 
}
 
void MixingVectors::bbUserInitializeProcessing()
{
 
}

void MixingVectors::bbUserFinalizeProcessing()
{
  
}
}
// EO namespace bbstd
