/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbstdReadVectorFromFile.h"
#include "bbstdPackage.h"
#include  <vector>
namespace bbstd
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(std,ReadVectorFromFile)
BBTK_BLACK_BOX_IMPLEMENTATION(ReadVectorFromFile,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ReadVectorFromFile::Process()
{
    std::vector< std::vector< double > > Data;
    std::ifstream openfile( bbGetInputFileName().c_str() );
    std::string Input;
    unsigned int LineLength=bbGetInputLineLength();
    int skip = 0;
    while ( getline( openfile, Input ) )
    {
       std::stringstream Parse;
       Parse << Input;
       double Value;
       std::vector<double> Line;
       // -------- une ligne sur 10!
       skip++;
       if(skip%10 != 0)
          continue;
       else
          skip=1;
       //--------       
       while ( Parse >> Value )
            Line.push_back( Value );
       if ( Line.size() != LineLength )
        {
            std::cout << "Line " << Data.size() + 1 << " expected " <<
            LineLength << " values, received " << Line.size() << " values, aborting." <<std::endl;
	    Data.clear();
        }
       Data.push_back( Line );
    }
    openfile.close();
    
    bbSetOutputOut(Data);
    printf("ReadVectorFromFile::Process end \n");	
	
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ReadVectorFromFile::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
//    Here we initialize the input 'In' to 0
	bbSetInputFileName("");
	bbSetInputLineLength(1);	  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ReadVectorFromFile::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 
    //Data = new vector< vector< double > >;
  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ReadVectorFromFile::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any
   //delete Data;
     
}
}
// EO namespace bbstd


