/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdRelay.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.11 $
=========================================================================*/

#ifndef __bbstdRelay_h_INCLUDED_H__
#define __bbstdRelay_h_INCLUDED_H__

#include "bbtkAtomicBlackBox.h"
#include "bbstd_EXPORT.h"

namespace bbstd
{
  //=======================================================================
  template <class T>
  class bbstd_EXPORT Relay
    :
  public bbtk::AtomicBlackBox
  {
    BBTK_TEMPLATE_BLACK_BOX_INTERFACE(Relay,bbtk::AtomicBlackBox,T);
    BBTK_DECLARE_INPUT(In,T);
    BBTK_DECLARE_OUTPUT(Out,T);
    BBTK_PROCESS(Process);
  protected:
    void Process() { bbSetOutputOut ( bbGetInputIn() ); }
  };
  //=======================================================================

  //=======================================================================
  BBTK_BEGIN_DESCRIBE_TEMPLATE_BLACK_BOX(Relay,bbtk::AtomicBlackBox);
  BBTK_NAME(bbtk::HumanTypeName<T>()+"Relay");
  BBTK_AUTHOR("laurent.guigues at creatis.insa-lyon.fr");
  BBTK_CATEGORY("misc");
  BBTK_DESCRIPTION("Just copies the value of its input to its output. Usefull to plug an input of a complex box into different internal boxes.");
  BBTK_TEMPLATE_INPUT(Relay,In,"Input",T);
  BBTK_TEMPLATE_OUTPUT(Relay,Out,"Output",T);
  BBTK_END_DESCRIBE_TEMPLATE_BLACK_BOX(Relay);
  //=======================================================================

  template <class T> void Relay<T>::bbUserSetDefaultValues() {}
  template <class T> void Relay<T>::bbUserInitializeProcessing() {}
  template <class T> void Relay<T>::bbUserFinalizeProcessing() {}

}
// namespace bbstd

//=======================================================================
// MACRO

#define BBTK_DEFINE_RELAY_BLACK_BOX(TYPE,PACKAGE,NAME)	\
class bb ## PACKAGE ## _EXPORT NAME : public bbtk::AtomicBlackBox { \
  BBTK_BLACK_BOX_INTERFACE(NAME,bbtk::AtomicBlackBox); \
  BBTK_DECLARE_INPUT(In,TYPE); \
  BBTK_DECLARE_OUTPUT(Out,TYPE); \
  BBTK_PROCESS(Process); \
 protected: \
  void Process() { bbSetOutputOut ( bbGetInputIn() ); } \
}; \
BBTK_BEGIN_DESCRIBE_BLACK_BOX(NAME,bbtk::AtomicBlackBox);\
BBTK_NAME(#NAME); \
BBTK_AUTHOR("laurent.guigues at creatis.insa-lyon.fr"); \
BBTK_CATEGORY("misc"); \
BBTK_DESCRIPTION("Just copies the value of its input to its output. Usefull to plug an input of a complex box into different internal boxes."); \
BBTK_INPUT(NAME,In,"Input",TYPE,"");\
BBTK_OUTPUT(NAME,Out,"Output",TYPE,"");\
BBTK_END_DESCRIBE_BLACK_BOX(NAME);

//=======================================================================

#endif // __bbstdRelay_h_INCLUDED_H__
