/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdSharedMemory.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.2 $
=========================================================================*/

#include "bbstdSharedMemory.h"
#include "bbstdPackage.h"
#include "bbtkBlackBoxOutputConnector.h"
using namespace bbtk;

namespace bbstd
{

  void SharedMemory::bbSetStatusAndPropagate(bbtk::BlackBoxInputConnector* c,
					 bbtk::IOStatus s)
  {
    bbtkDebugMessageInc("change",5,
			"=> SharedMemory::bbSetStatusAndPropagate(input,"
			<<GetIOStatusString(s)<<") ["
			<<bbGetFullName()<<"]"<<std::endl);
   if (mCanSet)
      {
	bbtkDebugMessageInc("change",5,"Memory writable"<<std::endl);
	if (c->IsConnected())
	  {
	    bbtkDebugMessageInc("change",5,"Input connected"<<std::endl);
	    // Transfer the data from the black box connected to the input
	    // which changed
	    c->GetConnection()->TransferData();
	    // Get the name of the input which changed
	    std::string input_name = c->GetConnection()->GetBlackBoxToInput();
	    // Set the output to the value of the input which changed
	    bbSetOutputOut( bbGetInput(input_name) ); 	
	  }
	// No more change allowed
	mCanSet = false;
      }
   BlackBox::bbSetStatusAndPropagate(c,s);
  }

  void SharedMemory::bbUserSetDefaultValues()
  {
    mCanSet = true;
  }
  void SharedMemory::bbUserInitializeProcessing() 
  { 
  }
  void  SharedMemory::bbUserFinalizeProcessing() 
  {
  }
  void SharedMemory::DoProcess()
  { 
    mCanSet = true;
  }

  BBTK_ADD_BLACK_BOX_TO_PACKAGE(std,SharedMemory);
  BBTK_BLACK_BOX_IMPLEMENTATION(SharedMemory,bbtk::AtomicBlackBox);
  
}
// EO namespace bbstd
