/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdStringTo.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.5 $
=========================================================================*/

#include "bbstdStringTo.h"
#include "bbstdPackage.h"


namespace bbstd 
{

  //====================================================================
  BBTK_BLACK_BOX_TEMPLATE_IMPLEMENTATION(StringTo,
					 bbtk::AtomicBlackBox);
  //====================================================================

  //====================================================================
  // Template specialization of DoIt
  template <> void StringTo<bool> ::DoIt()
  {
    if ( (bbGetInputIn()=="true") || 
         (bbGetInputIn()=="TRUE") || 
         (bbGetInputIn()=="True") || 
         (bbGetInputIn()=="1")     )  
    {
       bbSetOutputOut(true);
    }
    else if ( (bbGetInputIn()=="false") || 
              (bbGetInputIn()=="FALSE") ||
              (bbGetInputIn()=="False") ||
              (bbGetInputIn()=="0") )  
    {   
       bbSetOutputOut(false); 
    }
    else 
    {
       bbtkError("cannot convert '"<<bbGetInputIn()<<"' to a bool");
    }
  }
  
  // Template specialization of DoIt
  template <> void StringTo<bbtk::Void> ::DoIt()
  {
  }
  
  template <> void StringTo<int8_t> ::DoIt()
  {
    bbSetOutputOut( (int8_t)atoi ( bbGetInputIn().c_str() ) );
  }
  
  template <> void StringTo<uint8_t> ::DoIt()
  {
    bbSetOutputOut( (uint8_t)atoi ( bbGetInputIn().c_str() ) );
  }
  
  template <> void StringTo<int16_t> ::DoIt()
  {
    bbSetOutputOut( (int16_t)atoi ( bbGetInputIn().c_str() ) );
  }
  
  template <> void StringTo<uint16_t> ::DoIt()
  {
    bbSetOutputOut( (uint16_t)atoi ( bbGetInputIn().c_str() ) );
  }
  
  template <> void StringTo<int32_t> ::DoIt()
  {
    bbSetOutputOut( (int32_t)atoi ( bbGetInputIn().c_str() ) );
  }
  
  template <> void StringTo<uint32_t> ::DoIt()
  {
    bbSetOutputOut( (uint32_t)atoi ( bbGetInputIn().c_str() ) );
  }
  
  template <> void StringTo<float> ::DoIt()
  {
    bbSetOutputOut( (float)atof ( bbGetInputIn().c_str() ) );
  }
  
  template <> void StringTo<double> ::DoIt()
  {
    bbSetOutputOut( atof ( bbGetInputIn().c_str() ) );
  }
  
  //====================================================================
  
  //====================================================================
  // Add the specialized adaptors to the package
  typedef bbtk::Void Void;
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringTo,bool);
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringTo,int8_t);
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringTo,uint8_t);
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringTo,int16_t);
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringTo,uint16_t);
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringTo,int32_t);
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringTo,uint32_t);
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringTo,float);
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringTo,double);
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringTo,Void);
  //====================================================================
  
} // namespace bbstd
