/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbstdStringToVector.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:32 $
  Version:   $Revision: 1.6 $
=========================================================================*/


#include "bbstdStringToVector.h"
#include "bbstdPackage.h"


namespace bbstd
{
  //====================================================================
  BBTK_BLACK_BOX_TEMPLATE_IMPLEMENTATION(StringToVector,
					 bbtk::AtomicBlackBox);
  //====================================================================
  
  //====================================================================
  // Template specialization of decode_item
  template <> int8_t StringToVector<int8_t> ::decode_item(const std::string& s)
  {
    return (int8_t)atoi ( s.c_str() );
  }
  
  template <> uint8_t StringToVector<uint8_t> ::decode_item(const std::string& s)
  {
    return (uint8_t)atoi ( s.c_str() );
}

template <> int16_t StringToVector<int16_t> ::decode_item(const std::string& s)
{
  return (int16_t)atoi ( s.c_str() );
}

template <> uint16_t StringToVector<uint16_t> ::decode_item(const std::string& s)
{
  return (uint16_t)atoi ( s.c_str() );
}

template <> int32_t StringToVector<int32_t> ::decode_item(const std::string& s)
{
  return (int32_t)atoi ( s.c_str() );
}

template <> uint32_t StringToVector<uint32_t> ::decode_item(const std::string& s) 
{
  return (uint32_t)atoi ( s.c_str() );
}

template <> long StringToVector<long> ::decode_item(const std::string& s)
{
  // std::cout << bbGetFullName() << " v="<<s<<std::endl;
  return (long)atoi ( s.c_str() );
}

template <> float StringToVector<float> ::decode_item(const std::string& s)
{
  return (float)atof ( s.c_str() );
}

template <> double StringToVector<double> ::decode_item(const std::string& s)
{
  return atof ( s.c_str() );
}

template <> std::string StringToVector<std::string> ::decode_item(const std::string& s)
{
  return s;
}

//====================================================================

//====================================================================
// Add the specialized adaptors to the package

BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringToVector,int8_t);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringToVector,uint8_t);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringToVector,int16_t);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringToVector,uint16_t);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringToVector,int32_t);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringToVector,uint32_t);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringToVector,long);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringToVector,float);
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringToVector,double);
typedef std::string string;
BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(std,StringToVector,string);
//====================================================================

} // namespace bbstd
