/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbstdVectorRescaleSlope.h"
#include "bbstdPackage.h"
namespace bbstd
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(std,VectorRescaleSlope)
BBTK_BLACK_BOX_IMPLEMENTATION(VectorRescaleSlope,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void VectorRescaleSlope::Process()
{

// THE MAIN PROCESSING METHOD BODY
//   Here we simply set the input 'In' value to the output 'Out'
//   And print out the output value
// INPUT/OUTPUT ACCESSORS ARE OF THE FORM :
//    void bbSet{Input|Output}NAME(const TYPE&)
//    const TYPE& bbGet{Input|Output}NAME() const 
//    Where :
//    * NAME is the name of the input/output
//      (the one provided in the attribute 'name' of the tag 'input')
//    * TYPE is the C++ type of the input/output
//      (the one provided in the attribute 'type' of the tag 'input')
	
	unsigned int i;
	std::vector<double> result;
	double range[2];

	double A=bbGetInputA();
	double B=bbGetInputB();
	
	
	// -------------------------------------------------
	
	if (bbGetInputIn().size()>=1)	
	{
		range[0]=bbGetInputIn()[0];
		range[1]=bbGetInputIn()[0];
	} else {
		range[0]=999999;
		range[1]=-999999;
	}
	for (i=0; i<bbGetInputIn().size();i++)
	{
		if (range[0]>bbGetInputIn()[i])
		{
			range[0]=bbGetInputIn()[i];
		}
		if (range[1]<bbGetInputIn()[i])
		{
			range[1]=bbGetInputIn()[i];
		}
	}
	
	
	// -------------------------------------------------
	
	
	double range0plusrange1 = range[0]+range[1];
	double difrange			= range[1]-range[0];
	double newdifrange		= B-A;
	double shift;
	double scale;
	
	if (bbGetInputType()==0) // Rescale Slope/Intercept
	{ 
		//			newValue = value*A+B;
		scale = A;
		shift = B;
	} // if type 0
	
	if (bbGetInputType()==1) // Invert
	{ 
		//			newValue = value*(-1) + (range0plusrange1);
		scale=-1;
		shift=range0plusrange1;
	} // if type 1
	
	if (bbGetInputType()==2) // Redimension
	{ 
		//			newValue = ((value-range[0])/difrange)*newdifrange + A;
		scale=newdifrange/difrange;
		shift= A - (range[0]*newdifrange/difrange);
	} // if type 2
	
	if (bbGetInputType()==3) // Invert redimension
	{ 
		//			newValue = ((value*(-1)+range[1])/difrange)*newdifrange + A;
		scale=-newdifrange/difrange;
		shift= A + (range[1]*newdifrange/difrange);
	} // if type 3
	
		
	for (i=0; i<bbGetInputIn().size();i++)
	{
		result.push_back( bbGetInputIn()[i]*scale+shift );
	}
	
	bbSetOutputOut(result);
 
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void VectorRescaleSlope::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
//    Here we initialize the input 'In' to 0
	bbSetInputA(1);
	bbSetInputB(0);
	bbSetInputType(0);
	
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void VectorRescaleSlope::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 

  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void VectorRescaleSlope::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any
  
}
}
// EO namespace bbstd


