/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



#include "bbtkSimpleUtilities.h"
#define LOG_FILE_NAME "log.txt"

namespace bbtk
{


//template <typename T>





/*
namespace what
{
           std::string kind(int*);
           std::string is(int*, bool withkind=false);
           std::string kind(double* a);
           std::string is(double* a, bool withkind=false);
           std::string kind(float* a);
           std::string is(float* a, bool withkind=false);
           std::string kind(char* a);
           std::string is(char* a, bool withkind=false);
           std::string kind(long* a);
           std::string is(long* a, bool withkind=false);
           std::string kind(short* a);
           std::string is(short* a, bool withkind=false);
           std::string kind(bool* a);
           std::string is(bool* a, bool withkind=false);
           std::string kind(void* a);
           std::string is(void* a, bool withkind=false);

           std::string kind(unsigned int* a);
           std::string is(unsigned int* a, bool withkind=false);
           std::string kind(unsigned char* a);
           std::string is(unsigned char* a, bool withkind=false);
           std::string kind(unsigned long* a);
           std::string is(unsigned long* a, bool withkind=false);
           std::string kind(unsigned short* a);
           std::string is(unsigned short* a, bool withkind=false);
           std::string kind(__int64* a);
           std::string is(__int64* a, bool withkind=false);
           std::string kind(unsigned __int64* a);
           std::string is(unsigned __int64* a, bool withkind=false);
           std::string kind(long double* a);
           std::string is(long double* a, bool withkind=false);

           std::string kind(int a);
           std::string is(int a, bool withkind=false);
           std::string kind(double a);
           std::string is(double a, bool withkind=false);
           std::string kind(float a);
           std::string is(float a, bool withkind=false);
           std::string kind(short a);
           std::string is(short a, bool withkind=false);
           std::string kind(char a);
           std::string is(char a, bool withkind=false);
           std::string kind(long a);
           std::string is(long a, bool withkind=false);
           std::string kind(bool a);
           std::string is(bool a, bool withkind=false);
           std::string kind(unsigned int a);
           std::string is(unsigned int a, bool withkind=false);
           std::string kind(unsigned char a);
           std::string is(unsigned char a, bool withkind=false);
           std::string kind(unsigned long a);
           std::string is(unsigned long a, bool withkind=false);
           std::string kind(unsigned short a);
           std::string is(unsigned short a, bool withkind=false);
           std::string kind(__int64 a);
           std::string is(__int64 a, bool withkind=false);
           std::string kind(unsigned __int64 a);
           std::string is(unsigned __int64 a, bool withkind=false);
           std::string kind(long double a);
           std::string is(long double a, bool withkind=false);

           std::string kind(std::vector<int> a);
           std::string is(std::vector<int> a, bool withkind=false);
           std::string kind(std::vector<double> a);
           std::string is(std::vector<double> a, bool withkind=false);
           std::string kind(std::vector<float> a);
           std::string is(std::vector<float> a, bool withkind=false);
           std::string kind(std::vector<short> a);
           std::string is(std::vector<short> a, bool withkind=false);
           std::string kind(std::vector<char> a);
           std::string is(std::vector<char> a, bool withkind=false);
           std::string kind(std::vector<long> a);
           std::string is(std::vector<long> a, bool withkind=false);
           std::string kind(std::vector<bool> a);
           std::string is(std::vector<bool> a, bool withkind=false);
           std::string kind(std::vector<__int64> a);
           std::string is(std::vector<__int64> a, bool withkind=false);
           std::string kind(std::vector<unsigned int> a);
           std::string is(std::vector<unsigned int> a, bool withkind=false);
           std::string kind(std::vector<unsigned char> a);
           std::string is(std::vector<unsigned char> a, bool withkind=false);
           std::string kind(std::vector<unsigned long> a);
           std::string is(std::vector<unsigned long> a, bool withkind=false);
           std::string kind(std::vector<unsigned short> a);
           std::string is(std::vector<unsigned short> a, bool withkind=false);
           std::string kind(std::vector<long double> a);
           std::string is(std::vector<long double> a, bool withkind=false);

		   std::string is(double* a,int len=1, bool withkind=false);
		   std::string is(int* a,int len=1, bool withkind=false);
		   std::string is(float* a,int len=1, bool withkind=false);
		   std::string is(char* a,int len=1, bool withkind=false);

}
*/



	bool persistence::writeFile(std::string stm, std::string content)
	{
			std::ofstream myfile (stm.c_str());
			if (myfile.is_open())
			{
				myfile << content;
				myfile.close();
				return true;
			}
			else
			{
				return false;
			}
	}

	std::string persistence::readFile(std::string path)
	{
		std::string line;
		std::stringstream stm;
		std::ifstream myfile (path.c_str());
		if (myfile.is_open())
		{
			while (! myfile.eof() )
			{
				getline (myfile,line);
				stm << line << std::endl;
			}
			myfile.close();
		}
		else
		{

		}
		return stm.str();
	}




	std::string logging::fecha()
	{
		time_t seconds;
		seconds = time (NULL);

		//char timeStr [9];
		std::stringstream out;
                out << seconds;
		std::string la_fecha = out.str();
		//_strtime( timeStr );
		//std::string la_fecha(timeStr);
		return "["+la_fecha+"] ";
	}

	void logging::out(std::string texto)
	{
		std::ofstream outFile;
		outFile.open(LOG_FILE_NAME, std::ios::app);
		if (outFile)
		{
			outFile << fecha() << texto << std::endl;
		}
	}

	void logging::erase()
	{
		std::ofstream outFile;
		outFile.open(LOG_FILE_NAME, std::ios::out);
		if (outFile)
		{
			outFile << fecha() << "INICIO" << std::endl;
		}
	}


	std::vector<std::string> translate::StringSplit(std::string str, std::string delim)
	{
		std::vector<std::string> results;
		int cutAt;
		while( (cutAt = (int)str.find_first_of(delim)) != str.npos )
		{
			if(cutAt > 0)
			{
				results.push_back(str.substr(0,cutAt));
			}
				str = str.substr(cutAt+1);
			}
			if(str.length() > 0)
			{
				results.push_back(str);
			}
		return results;
	}

	std::vector<double> translate::stringTovector(std::string texto, std::string start, std::string end)
	{
		std::vector<double> el_vector;
		std::vector<std::string> partes;


		int inicial = (int)texto.find( start, 0 );
		int final = (int)texto.find( end, 0 );

		if (inicial == std::string::npos || final == std::string::npos)
			return el_vector;
		if (final<=inicial)
			return el_vector;

		std::string contenido = texto.substr(inicial+1, final-inicial-1);

		partes = StringSplit(contenido, ",");
		if (partes.size() != -1){
			for (int i=0; i<(int)partes.size(); i++)
			{
				if (partes.at(i).size() > 0)
				{
					double uno = atof(partes.at(i).data());
					el_vector.push_back(uno);
				}
			}
		}
		return el_vector;
	}

	std::vector<double> translate::stringTovectorDelimited(std::string texto, std::string delimitador)
	{
		std::vector<double> el_vector;
		std::vector<std::string> partes;

		std::string contenido = texto;

		partes = StringSplit(contenido, delimitador);
		if (partes.size() != -1){
			for (int i=0; i<(int)partes.size(); i++)
			{
				double uno = atof(partes.at(i).data());
				el_vector.push_back(uno);
			}
		}
		return el_vector;
	}

    double* translate::stringToArray(std::string texto)
	{
        std::vector<double> el_vector = stringTovector(texto);
        double* array = new double[el_vector.size()];
        for (int i=0; i<(int)el_vector.size(); i++)
        {
            array[i]=el_vector[i];
        }
		return array;
	}

	std::string translate::getInnerInfo(std::string texto)
	{
		int first_par = (int)texto.find("[", 0);
		int last_par = (int)texto.rfind("]", texto.size());

		return texto.substr(first_par+1,last_par-first_par-1);
	}

	std::vector<double*> translate::stringToVectorArray(std::string texto)
	{
		std::vector<double*> el_vector;
		std::string innerInfo = getInnerInfo(texto);

		int first_par = 0;
		int last_par = 0;
		int lastComma = 0;

		while (lastComma != std::string::npos)
		{
			first_par = (int)innerInfo.find("[", lastComma);
			last_par = (int)innerInfo.find("]", lastComma);
			lastComma = (int)innerInfo.find(",", last_par);
			if (first_par == std::string::npos || last_par == std::string::npos)
				break;
			std::string subArreglo = innerInfo.substr(first_par,last_par-first_par+1);
			double* subArray = stringToArray(subArreglo);
			el_vector.push_back(subArray);
		}
		return el_vector;
	}

	std::string translate::vectorToStringDelimited(std::vector<double> a, std::string delim)
	{
		std::stringstream out;

        unsigned int i;
        for (i = 0; i < a.size(); i++)
        {
            out << a.at(i);
            if (i != a.size()-1)
                out << delim;
        }
        return out.str();
	}



//Recorre el vector de manera ciclica
double vectores::vectorInfinite(std::vector<double> in, int index)
{
    //std::cout << "index = " << index;
    int value;
	int tamanio = in.size();
	bool inverso = false;
	if (tamanio == 0)
		return -1;

	if (index < 0)
	{
		inverso = true;
		index = abs(index);
		value = tamanio - index%tamanio;
		if (value == tamanio)
		   value = 0;
	}else{
		value = index%tamanio;
	}
	//std::cout << ", value=" << value << std::endl;
	//return 0;
    return in.at(value);
}



	/**
	Ordenamiento busbuja, array[0] es el maximo
	http://mathbits.com/mathbits/compsci/Arrays/Bubble.htm
	**/
	void sorts::bubble(std::vector<double> &array)
	{
		double i, j, flag = 1;    // set flag to 1 to begin initial pass
		double temp;             // holding variable
		double arrayLength = array.size();
		for(i = 1; (i <= arrayLength) && flag; i++)
		{
			flag = 0;
			for (j=0; j < (arrayLength -1); j++)
			{
				if (array[(int)(j+1)] > array[(int)j])      // ascending order simply changes to <
				{
						temp = array[(int)j];             // swap elements
						array[(int)j] = array[(int)(j+1)];
						array[(int)(j+1)] = temp;
						flag = 1;               // indicates that a swap occurred.
				}
			}
		}
	}

};


