/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "bbtkStaticLecture.h"


	void bbtkStaticLecture::setPixelValue(int i, int j, int k, vtkImageData* img, double value)
	{
		//double rta;
		int scalar_type = img->GetScalarType();
		int* ext = img->GetExtent();
		if (i < ext[0])
			return;
		if (i > ext[1])
			return;

		if (j < ext[2])
			return;
		if (j > ext[3])
			return;

		if (k < ext[4])
			return;
		if (k > ext[5])
			return;

		switch (scalar_type)
		{
			case VTK_CHAR:
				char * ap2;
				ap2 = (char *) img->GetScalarPointer(i,j,k);
				*ap2 = (char) value;
			break;
			case VTK_UNSIGNED_CHAR:
				unsigned char * ap3;
				ap3 = (unsigned char *) img->GetScalarPointer(i,j,k);
				*ap3 = (unsigned char) value;
			break;
			case VTK_SHORT:
				short * ap4;
				ap4 = (short *) img->GetScalarPointer(i,j,k);
				*ap4 = (short) value;
			break;
			case VTK_UNSIGNED_SHORT:
				unsigned short * ap5;
				ap5 = (unsigned short *) img->GetScalarPointer(i,j,k);
				*ap5 = (unsigned short) value;
			break;
			case VTK_INT:
				int * ap6;
				ap6 = (int *) img->GetScalarPointer(i,j,k);
				*ap6 = (int) value;
			break;
			case VTK_UNSIGNED_INT:
				unsigned int * ap7;
				ap7 = (unsigned int *) img->GetScalarPointer(i,j,k);
				*ap7 = (unsigned int) value;
			break;
			case VTK_LONG:
				long * ap8;
				ap8 = (long *) img->GetScalarPointer(i,j,k);
				*ap8 = (long) value;
			break;
			case VTK_UNSIGNED_LONG:
				unsigned long * ap9;
				ap9 = (unsigned long *) img->GetScalarPointer(i,j,k);
				*ap9 = (unsigned long) value;
			break;
			case VTK_FLOAT:
				float * ap10;
				ap10 = (float *) img->GetScalarPointer(i,j,k);
				*ap10 = (float) value;
			break;
			case VTK_DOUBLE:
				double * ap11;
				ap11 = (double *) img->GetScalarPointer(i,j,k);
				*ap11 = (double) value;
			break;
		}
	}
	double bbtkStaticLecture::getPixelValue(int i, int j, int k, vtkImageData* img)
	{
		double rta;
		int scalar_type = img->GetScalarType();
		int* ext = img->GetExtent();
		if (i < ext[0])
			i=ext[0];
		if (i > ext[1])
			i=ext[1];

		if (j < ext[2])
			j=ext[2];
		if (j > ext[3])
			j=ext[3];

		if (k < ext[4])
			k=ext[4];
		if (k > ext[5])
			k=ext[5];

		switch (scalar_type)
		{
			case VTK_CHAR:
				char * ap2;
				ap2 = (char *) img->GetScalarPointer(i,j,k);
				rta = (double) *ap2;
			break;
			case VTK_UNSIGNED_CHAR:
				unsigned char * ap3;
				ap3 = (unsigned char *) img->GetScalarPointer(i,j,k);
				rta = (double) *ap3;
			break;
			case VTK_SHORT:
				short * ap4;
				ap4 = (short *) img->GetScalarPointer(i,j,k);
				rta = (double) *ap4;
			break;
			case VTK_UNSIGNED_SHORT:
				unsigned short * ap5;
				ap5 = (unsigned short *) img->GetScalarPointer(i,j,k);
				rta = (double) *ap5;
			break;
			case VTK_INT:
				int * ap6;
				ap6 = (int *) img->GetScalarPointer(i,j,k);
				rta = (double) *ap6;
			break;
			case VTK_UNSIGNED_INT:
				unsigned int * ap7;
				ap7 = (unsigned int *) img->GetScalarPointer(i,j,k);
				rta = (double) *ap7;
			break;
			case VTK_LONG:
				long * ap8;
				ap8 = (long *) img->GetScalarPointer(i,j,k);
				rta = (double) *ap8;
			break;
			case VTK_UNSIGNED_LONG:
				unsigned long * ap9;
				ap9 = (unsigned long *) img->GetScalarPointer(i,j,k);
				rta = (double) *ap9;
			break;
			case VTK_FLOAT:
				float * ap10;
				ap10 = (float *) img->GetScalarPointer(i,j,k);
				rta = (double) *ap10;
			break;
			case VTK_DOUBLE:
				double * ap11;
				ap11 = (double *) img->GetScalarPointer(i,j,k);
				rta = (double) *ap11;
			break;
		}
		return rta;
	}
