/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "bbvtkCSVReader.h"
#include "bbvtkPackage.h"
namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,CSVReader)
BBTK_BLACK_BOX_IMPLEMENTATION(CSVReader,bbtk::AtomicBlackBox);
void CSVReader::Process()
{
    if (bbGetInputIn().size() == 0)
	{
		std::cout << "Set In with the file path to the csv file" << std::endl;
		return;
	}

	std::vector< std::vector< double > > matrix;
	int tamaniox = 0;
	int tamanioy = 0;

	std::string line;
	std::ifstream myfile (bbGetInputIn().c_str());
	if (myfile.is_open())
	{
		while (! myfile.eof() )
		{
			getline (myfile,line);
			if (line.size() > 0)
			{
			    bbtk::translate t;
				std::vector< double > numeros = t.stringTovectorDelimited(line, ",");
				if (numeros.size() > 0)
				{
					tamanioy = numeros.size();
					matrix.push_back(numeros);
					tamaniox++;
				}
			}
		}
		myfile.close();

		//Se arma la imagen vtk

		vtkImageData* ans = createImage(matrix, tamaniox, tamanioy, bbGetInputInType());

		bbSetOutputOut(ans);
	}
	else
	{

	}

}
void CSVReader::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX
//    Here we initialize the input 'In' to 0
   std::string path = "";
   bbSetInputIn(path);

   bbSetOutputOut(NULL);

}
void CSVReader::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should allocate the internal/output pointers
//    if any


}
void CSVReader::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should desallocate the internal/output pointers
//    if any

}
vtkImageData* CSVReader::createImage(std::vector< std::vector<double> > info, int x, int y, int scalar_type)
{
	vtkImageData* final = vtkImageData::New();

	//int ext[6];
	int newDim[3];
	//double space[3];
	double origin[3];

	//original->GetSpacing(space);
	//original->GetExtent(ext);
	//original->GetOrigin(origin);
	//original->GetDimensions(newDim);

	final->SetScalarType(scalar_type);

	//final->SetSpacing(space);
	newDim[0] = x;
	newDim[1] = y;
	newDim[2] = 1;
	final->SetDimensions(newDim);
	origin[0] = 0;
	origin[1] = 0;
	origin[2] = 0;
	final->SetOrigin(origin);

	final->AllocateScalars();
	final->Update();

	for (int i=0; i<newDim[0]; i++){
		for (int j=0; j<newDim[1]; j++){
			switch (scalar_type)
			{
				case VTK_CHAR:
					char * ap2;
					ap2 = (char *) final->GetScalarPointer(i,j,0);
					*ap2 = (char)info.at(i).at(j);
				break;
				case VTK_UNSIGNED_CHAR:
					unsigned char * ap3;
					ap3 = (unsigned char *) final->GetScalarPointer(i,j,0);
					*ap3 = (unsigned char)info.at(i).at(j);
				break;
				case VTK_SHORT:
					short * ap4;
					ap4 = (short *) final->GetScalarPointer(i,j,0);
					*ap4 = (short)info.at(i).at(j);
				break;
				case VTK_UNSIGNED_SHORT:
					unsigned short * ap5;
					ap5 = (unsigned short *) final->GetScalarPointer(i,j,0);
					*ap5 = (unsigned short)info.at(i).at(j);
				break;
				case VTK_INT:
					int * ap6;
					ap6 = (int *) final->GetScalarPointer(i,j,0);
					*ap6 = (int)info.at(i).at(j);
				break;
				case VTK_UNSIGNED_INT:
					unsigned int * ap7;
					ap7 = (unsigned int *) final->GetScalarPointer(i,j,0);
					*ap7 = (unsigned int)info.at(i).at(j);
				break;
				case VTK_LONG:
					long * ap8;
					ap8 = (long *) final->GetScalarPointer(i,j,0);
					*ap8 = (long)info.at(i).at(j);
				break;
				case VTK_UNSIGNED_LONG:
					unsigned long * ap9;
					ap9 = (unsigned long *) final->GetScalarPointer(i,j,0);
					*ap9 = (unsigned long)info.at(i).at(j);
				break;
				case VTK_FLOAT:
					float * ap10;
					ap10 = (float *) final->GetScalarPointer(i,j,0);
					*ap10 = (float)info.at(i).at(j);
				break;
				case VTK_DOUBLE:
					double * ap11;
					ap11 = (double *) final->GetScalarPointer(i,j,0);
					*ap11 = (double)info.at(i).at(j);
				break;
			}
		}
	}
	return final;
}
}
// EO namespace bbPersistence


