/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbvtkCleanExternalPlane.h"
#include "bbvtkPackage.h"
namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,CleanExternalPlane)
BBTK_BLACK_BOX_IMPLEMENTATION(CleanExternalPlane,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void CleanExternalPlane::Process()
{

// THE MAIN PROCESSING METHOD BODY
//   Here we simply set the input 'In' value to the output 'Out'
//   And print out the output value
// INPUT/OUTPUT ACCESSORS ARE OF THE FORM :
//    void bbSet{Input|Output}NAME(const TYPE&)
//    const TYPE& bbGet{Input|Output}NAME() const 
//    Where :
//    * NAME is the name of the input/output
//      (the one provided in the attribute 'name' of the tag 'input')
//    * TYPE is the C++ type of the input/output
//      (the one provided in the attribute 'type' of the tag 'input')

	if ( bbGetInputIn()!=NULL )
	{
		int i,j;
		int ext[6];
		int dim[3];
		bbGetInputIn()->GetWholeExtent(ext);
		
		dim[0]=ext[1]-ext[0]+1;
		dim[1]=ext[3]-ext[2]+1;
		dim[2]=ext[5]-ext[4]+1;
		
		// XY plane
		for (i=0 ; i<dim[0] ; i++)
		{
			for (j=0 ; j<dim[1] ; j++)
			{
				bbGetInputIn()->SetScalarComponentFromDouble (i, j, 0		, 0, 0.0);
				bbGetInputIn()->SetScalarComponentFromDouble (i, j, dim[2]-1, 0, 0.0);
			}
		}
		
		// YZ plane
		for (i=0 ; i<dim[1] ; i++)
		{
			for (j=0 ; j<dim[2] ; j++)
			{
				bbGetInputIn()->SetScalarComponentFromDouble (0			, i, j, 0, 0.0);
				bbGetInputIn()->SetScalarComponentFromDouble (dim[0]-1	, i, j, 0, 0.0);
			}
		}
		
		// YZ plane
		for (i=0 ; i<dim[0] ; i++)
		{
			for (j=0 ; j<dim[2] ; j++)
			{
				bbGetInputIn()->SetScalarComponentFromDouble (i, 0			, j, 0, 0.0);
				bbGetInputIn()->SetScalarComponentFromDouble (i, dim[1]-1	, j, 0, 0.0);
			}
		}
	
		
	}
    
	
	bbSetOutputOut( bbGetInputIn() );

	
	
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void CleanExternalPlane::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
//    Here we initialize the input 'In' to 0
   bbSetInputIn(0);
  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void CleanExternalPlane::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 

  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void CleanExternalPlane::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any
  
}
}
// EO namespace bbvtk


