/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkConcatImages.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.3 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */

#ifdef _USE_VTK_
#include "bbvtkConcatImages.h"
#include "bbvtkPackage.h"

namespace bbvtk
{
   BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,ConcatImages)
   BBTK_BLACK_BOX_IMPLEMENTATION(ConcatImages,bbtk::AtomicBlackBox);

//---------------------------------------------------------------------

   void ConcatImages::bbUserSetDefaultValues() 
   { 
      //std::cout << "-------- entree ds ConcatImages::bbUserSetDefaultValues()\n" << std::endl;
      
   // bbSetInputIn(NULL);  /// \TODO fix it! IN is a std::vector<vtkImageData> // JPR
      mConcat = NULL;
      bbSetOutputOut(NULL);
   }

//---------------------------------------------------------------------

   void ConcatImages::bbUserInitializeProcessing() 
   {
       //std::cout << "-------- entree ds ConcatImages::bbUserInitalizeProcessing()\n" << std::endl;
      //bbUserFinalizeProcessing();
      mConcat = vtkImageData::New();  // Alloc depends on  bbGetInputIn().size()  
   }
  
//---------------------------------------------------------------------

   void ConcatImages::bbUserFinalizeProcessing() 
   {
            //std::cout << "-------- entree ds ConcatImages::bbUserFinalizeProcessing()\n" << std::endl;
   // WTF? we never enter here // JPR  bbUserFinalizeProcessing()  JPR	
      if (mConcat!=NULL)
      {
        // mConcat->Delete();
        // mConcat=NULL;
      }
      bbSetOutputOut(mConcat);          
   }

//---------------------------------------------------------------------
 
 /// \TODO :clean this dirty stuff :
 ///  - receives a std::vector<vtkImageData*>
 ///  - exports a vtkImageData*
 ///  - supposes *all* the images are consistent (same type, same number of components, same pixel type)
 ///  - if images in the vector are already 3D, exports only the first one. ?!?  // JPR
 ///
   void ConcatImages::Process()
   {
        int dim[3];
        int curDim[3];
	int nbComponents;
	int scalarType;
	int nb = (unsigned int)bbGetInputIn().size();
//	int consistentNb(nb);
	int newSizeZ;

        if (nb == 0) {
	   // ??? JPR
	} 
	
	bbGetInputIn()[0]->GetDimensions(dim);
	if ( nb == 1) // dim[2] > 1 : Hopeless for vtk : the first file contains already a 3D object
				    // nb == 1 : only one image, nothing to do.
	{
	   mConcat->Delete();
	   mConcat = bbGetInputIn()[0];
	   //mConcat->PrintSelf(std::cout, vtkIndent(2));
	} else {
	   // We suppose *all* the images within the directory are consistent (same sizeS, same pixel Type?...)
	   vtkImageData * firstImage = bbGetInputIn()[0];
	   
		  //std::cout << "--------PrintSelf firstImage " << std::endl;
		  // firstImage->PrintSelf(std::cout, vtkIndent(2));	   
	   
           nbComponents = firstImage->GetNumberOfScalarComponents();
           mConcat->SetNumberOfScalarComponents(nbComponents);
	   
	   mConcat->SetScalarType(firstImage->GetScalarType( ));
	   scalarType = firstImage->GetScalarType( );
	   mConcat->SetScalarType(scalarType);
	   
	   mConcat->SetSpacing(firstImage->GetSpacing());
	   
	   firstImage->GetDimensions(dim);
	   newSizeZ=0;
	   // brute way to perform an ultra-mini consistency check :
	   // First image is supposed to be the reference image,
	   // any unconsistent image is just discarted...
	   for(int i=0; i<nb; i++)
	   {

//EED 2013 oct 29 
//EED	      if ( !CheckConsistency(firstImage, dim, nbComponents, scalarType))
//EED	        consistentNb--;

	      if ( CheckConsistency(bbGetInputIn()[i], dim, nbComponents, scalarType))
		{
			bbGetInputIn()[i]->GetDimensions(curDim);
			newSizeZ = newSizeZ + curDim[2];
		} // if
		
	   }    // for

	   dim[2]=newSizeZ;


	   mConcat->SetDimensions(dim);
	   mConcat->SetExtent(0, dim[0]-1, 0, dim[1]-1, 0, dim[2]-1);
	   	   
	   mConcat->AllocateScalars();
	   mConcat->Update();	   
		     
	   int index_image;

	   int blocksize;
	   int scalarSize=bbGetInputIn()[0]->GetScalarSize();
	   char *pImage = (char*)mConcat->GetScalarPointer();
	   char *sourcePointer;

//EED	   int index_lignes, index_colonnes, index_components;
	
   
	   for(index_image=0; index_image<nb; index_image++)
	   {
	      if (!CheckConsistency(bbGetInputIn()[index_image], dim, nbComponents, scalarType))
		{
		         continue;  // discard unconsistent image !
		}
	      bbGetInputIn()[index_image]->GetDimensions(curDim);
	      blocksize = curDim[0]*curDim[1]*curDim[2]*nbComponents*scalarSize;
          sourcePointer = (char*)bbGetInputIn()[index_image]->GetScalarPointer();
	      memcpy(pImage, sourcePointer,blocksize);
          pImage = pImage+blocksize;

//EED 2013 oct 29 
//EED	      for(index_lignes=0; index_lignes<dim[0];index_lignes++)
//EED	      {
//EED	         for(index_colonnes=0; index_colonnes<dim[1];index_colonnes++)
//EED	         {
//EED	            for(index_components=0; index_components<nbComponents;index_components++)
//EED		    { 
//EED		      mConcat->SetScalarComponentFromDouble(index_lignes, index_colonnes, index_image, index_components,(bbGetInputIn()[index_image])->GetScalarComponentAsDouble(index_colonnes,index_lignes,0,index_components));
//EED		    } // components
//EED	         } // colonnes
//EED	      } // lignes


	   } // if CheckConsistency
	} /// for index_image

   // Devrait etre dans bbUserFinalizeProcessing() ? On n'y entre jamais // JPR	
   bbSetOutputOut(mConcat);   	
   }		   

bool ConcatImages::CheckConsistency( vtkImageData *curImage, int dim[], int nbComponents, int scalarType )
{
   assert (curImage);
   
   if (scalarType != curImage->GetScalarType( ) )
   {
      return false;
   }      

   if (nbComponents != curImage->GetNumberOfScalarComponents() )
   {
      return false;
   }
     
   int curDim[3];
   curImage->GetDimensions(curDim);
   if ( (curDim[0] =! dim[0]) || (curDim[1] =! dim[1]) )
   {
      return false;
   }

   return true;   
}


}//namespace bbtk

#endif // _USE_VTK_
