/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbvtkCreateImage.h"
#include "bbvtkPackage.h"
namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,CreateImage)
BBTK_BLACK_BOX_IMPLEMENTATION(CreateImage,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void CreateImage::Process()
{

// THE MAIN PROCESSING METHOD BODY
//   Here we simply set the input 'In' value to the output 'Out'
//   And print out the output value
// INPUT/OUTPUT ACCESSORS ARE OF THE FORM :
//    void bbSet{Input|Output}NAME(const TYPE&)
//    const TYPE& bbGet{Input|Output}NAME() const 
//    Where :
//    * NAME is the name of the input/output
//      (the one provided in the attribute 'name' of the tag 'input')
//    * TYPE is the C++ type of the input/output
//      (the one provided in the attribute 'type' of the tag 'input')

	
       printf("EED CreateImage::Process Start\n");

	double	spc[6];
	int		dim[3];	
	int		outputformat = VTK_UNSIGNED_SHORT;
	

	if (bbGetInputOutputFormat()=="VTK_BIT")			outputformat = VTK_BIT;                 // 1
	else if (bbGetInputOutputFormat()=="VTK_CHAR")			outputformat = VTK_CHAR;		// 2
	else if (bbGetInputOutputFormat()=="VTK_SIGNED_CHAR")		outputformat = VTK_SIGNED_CHAR;     	// 15
	else if (bbGetInputOutputFormat()=="VTK_UNSIGNED_CHAR")		outputformat = VTK_UNSIGNED_CHAR;       // 3
	else if (bbGetInputOutputFormat()=="VTK_SHORT")			outputformat = VTK_SHORT;               // 4
	else if (bbGetInputOutputFormat()=="VTK_UNSIGNED_SHORT")	outputformat = VTK_UNSIGNED_SHORT;      // 5
	else if (bbGetInputOutputFormat()=="VTK_INT")			outputformat = VTK_INT;                 // 6
	else if (bbGetInputOutputFormat()=="VTK_UNSIGNED_INT")		outputformat = VTK_UNSIGNED_INT;        // 7 
	else if (bbGetInputOutputFormat()=="VTK_LONG")			outputformat = VTK_LONG;                // 8
	else if (bbGetInputOutputFormat()=="VTK_UNSIGNED_LONG")		outputformat = VTK_UNSIGNED_LONG;       // 9
	else if (bbGetInputOutputFormat()=="VTK_FLOAT")			outputformat = VTK_FLOAT;               // 10
	else if (bbGetInputOutputFormat()=="VTK_DOUBLE")		outputformat = VTK_DOUBLE;              // 11  
		
	spc[0] = bbGetInputSpacing()[0];
	spc[1] = bbGetInputSpacing()[1];
	spc[2] = bbGetInputSpacing()[2];
	
	dim[0] =  bbGetInputDimensions()[0];
	dim[1] =  bbGetInputDimensions()[1];
	dim[2] =  bbGetInputDimensions()[2];
	
	imageoutput->Initialize();
	imageoutput->SetScalarType( outputformat );	
	imageoutput->SetSpacing( spc );
	imageoutput->SetDimensions(  dim[0], dim[1], dim[2] );
	imageoutput->AllocateScalars();
	

		int i,j,k;
		long sizeBlock;	

		for (i=0; i<dim[0]; i++)
		{
			imageoutput->SetScalarComponentFromDouble(i,0,0, 0, bbGetInputInitialValue() );
		}
		
		sizeBlock= dim[0] * imageoutput->GetScalarSize();
                for (j=1; j<dim[1]; j++)
		{
			memcpy(  imageoutput->GetScalarPointer(0,j,0), imageoutput->GetScalarPointer()  , sizeBlock );
		}		

		sizeBlock= dim[0] * dim[1] * imageoutput->GetScalarSize();
		for (k=0; k<dim[2]; k++)
		{
			memcpy(  imageoutput->GetScalarPointer(0,0,k) ,imageoutput->GetScalarPointer()  , sizeBlock );
		} // for k

		imageoutput->Update();
		imageoutput->Modified();
		bbSetOutputOut(imageoutput);

 printf("EED CreateImage::Process End\n");

}	
	
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void CreateImage::bbUserSetDefaultValues()
{
	imageoutput=NULL;

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
	std::vector<int> dim;
	dim.push_back(250);
	dim.push_back(250);
	dim.push_back(250);
	std::vector<double> spc;
	spc.push_back(1.0);
	spc.push_back(1.0);
	spc.push_back(1.0);
	
	bbSetInputDimensions(dim);
	bbSetInputSpacing(spc);
	bbSetInputOutputFormat("VTK_UNSIGNED_SHORT");
	bbSetInputInitialValue(0);
}
	
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void CreateImage::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 

  	imageoutput = vtkImageData::New();

}
	
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void CreateImage::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any
  	imageoutput->Delete();

}
}
// EO namespace bbvtk


