/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkFlip.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.5 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */

#ifdef _USE_VTK_
#include "bbvtkFlip.h"
#include "bbvtkPackage.h"

namespace bbvtk
{
   BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,Flip)
   BBTK_BLACK_BOX_IMPLEMENTATION(Flip,bbtk::AtomicBlackBox);

//---------------------------------------------------------------------

   void Flip::bbUserSetDefaultValues() 
   { 
      //std::cout << "-------- entree ds Flip::bbUserSetDefaultValues()\n" << std::endl;
      
      bbSetInputIn(NULL); 
      bbSetInputAxis("Y"); 
      mImageOut = NULL;
      bbSetOutputOut(NULL);
   }

//---------------------------------------------------------------------

   void Flip::bbUserInitializeProcessing() 
   {
       //std::cout << "-------- entree ds Flip::bbUserInitalizeProcessing()\n" << std::endl;
   }
  
//---------------------------------------------------------------------

   void Flip::bbUserFinalizeProcessing() 
   {
            //std::cout << "-------- entree ds Flip::bbUserFinalizeProcessing()\n" << std::endl;
   // WTF? we never enter here // JPR  bbUserFinalizeProcessing()  JPR	
      if (mImageOut!=NULL)
      {
        mImageOut->Delete();
        mImageOut=NULL;
      }
      bbSetOutputOut(mImageOut);          
   }

//---------------------------------------------------------------------
 
 ///  :
 ///  - receives a vtkImageData*imageIn, flips it
 ///  - exports a vtkImageData*  
 ///  
 ///
void Flip::Process()
{
	
	if (bbGetInputIn()!=NULL)
	{
		if (mImageOut!=NULL)
		{
			mImageOut->Delete();
			mImageOut=NULL;
		} // if mImageOut
	
		mImageOut = vtkImageData::New();  // Alloc depends on  bbGetInputIn().size()  
		mImageOut->Initialize();
		mImageOut->SetScalarType(  bbGetInputIn()->GetScalarType() );
		mImageOut->SetSpacing(   bbGetInputIn()->GetSpacing()  );
		mImageOut->SetDimensions(   bbGetInputIn()->GetDimensions()  );
		mImageOut->SetNumberOfScalarComponents( bbGetInputIn()->GetNumberOfScalarComponents() );
		mImageOut->AllocateScalars();
	
		int inputdims[3];
		//   int outputdims[3];
		bbGetInputIn()->GetDimensions (inputdims);
		bbGetInputIn()->Update();
		int nbScalComp	= bbGetInputIn()->GetNumberOfScalarComponents();
		int scalarSize	= bbGetInputIn()->GetScalarSize();
		int lineSize	= inputdims[0]*scalarSize*nbScalComp;	   
		int planeSize	= inputdims[1]*lineSize;
                int volumeSize  = inputdims[2]*planeSize;
		char *pixelsIn	= (char *)bbGetInputIn()->GetScalarPointer();
		char *pixelsOut = (char *)mImageOut->GetScalarPointer();
	
		char *lineIn;
		char *lineOut;
		char *debPlanIn;
		char *debPlanOut;
		int i,j,k;
		
		if ( (bbGetInputAxis()=="O") || (bbGetInputAxis()=="o") )
		{  
		        pixelsIn = (char *)bbGetInputIn()->GetScalarPointer(0,0,0);
			pixelsOut = (char *)mImageOut->GetScalarPointer(0,0,0);
			memcpy(pixelsOut,  pixelsIn, volumeSize );
		} else if ( (bbGetInputAxis()=="X") || (bbGetInputAxis()=="x") )
		{  

  		   	for(k=0; k<inputdims[2]; k++)  // iterate  planes
			{  
				for(j=0; j<inputdims[1]; j++)  // iterates  rows
				{ 
					for(i=0; i<inputdims[0]; i++)  // iterates  columns
					{ 
						pixelsIn = (char *)bbGetInputIn()->GetScalarPointer(i,j,k);
						pixelsOut = (char *)mImageOut->GetScalarPointer(inputdims[0]-1-i,j,k);
						memcpy(pixelsOut,  pixelsIn, scalarSize );
					}	// for i
				}	// for j
			} // for k

		} else if ( (bbGetInputAxis()=="Z") || (bbGetInputAxis()=="z") )  {  

  		   	for(k=0; k<inputdims[2]; k++)  // iterate  planes
			{  
				for(j=0; j<inputdims[1]; j++)  // iterates  rows
				{ 
					for(i=0; i<inputdims[0]; i++)  // iterates  columns
					{ 
						pixelsIn = (char *)bbGetInputIn()->GetScalarPointer(i,j,k);
						pixelsOut = (char *)mImageOut->GetScalarPointer(i,j,inputdims[2]-1-k);
						memcpy(pixelsOut,  pixelsIn, scalarSize );
					}	// for i
				}	// for j
			} // for k

		} else {  

  		   	for(k=0; k<inputdims[2]; k++)  // iterate  planes
			{  
				debPlanIn	= pixelsIn+k*planeSize;
				debPlanOut	= pixelsOut+k*planeSize;
				for(j=0; j<inputdims[1]; j++)  // iterates  rows
				{ 
					lineIn = debPlanIn+j*lineSize;
					lineOut = debPlanOut+(inputdims[1]-1-j)*lineSize;
					memcpy(lineOut,  lineIn, lineSize);
				}	// for j
			} // for k

		} //if
		mImageOut->Modified();
		bbSetOutputOut( mImageOut  );   	
	} // bbGetInputIn

}


}//namespace bbtk

#endif // _USE_VTK_
