/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbvtkImageBoundaries.h"
#include "bbvtkPackage.h"
namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,ImageBoundaries)
BBTK_BLACK_BOX_IMPLEMENTATION(ImageBoundaries,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ImageBoundaries::Process()
{
	printf("bbtk:vtk::ImageBoundaries::Process start\n");
	if (bbGetInputIn()!=NULL){
		int i,j,k;	
		int ext[6];
		double value;
		
		bbGetInputIn()->GetWholeExtent(ext);
		int maxX	= ext[1]-ext[0]+1;
		int maxY	= ext[3]-ext[2]+1;
		int maxZ	= ext[5]-ext[4]+1;
				
		int bXMax	= 0;
		int bYMax	= 0;
		int bZMax	= 0;
		int bXMin	= maxX-1;
		int bYMin	= maxY-1;
		int bZMin	= maxZ-1;
		
		for (i=0 ; i<maxX ; i++)
		{
			for (j=0 ; j<maxY ; j++)
			{
				for (k=0 ; k<maxZ ; k++)
				{
					value = bbGetInputIn()->GetScalarComponentAsDouble(i, j, k,0);
					if ( (value>=bbGetInputLowerValue()) && (value<=bbGetInputUpperValue())  )
					{
						if (i<bXMin) bXMin=i;
						if (j<bYMin) bYMin=j;
						if (k<bZMin) bZMin=k;
						if (i>bXMax) bXMax=i;
						if (j>bYMax) bYMax=j;
						if (k>bZMax) bZMax=k;
					}
				} // for k
			} // for j
		} // i
			
		std::vector<int> tmpIndex;		
		std::vector<int> tmpSize;
		
		if (bXMin>bXMax){
			tmpIndex.push_back(0);
			tmpIndex.push_back(0);
			tmpIndex.push_back(0);
			tmpSize.push_back(1);
			tmpSize.push_back(1);
			tmpSize.push_back(1);
		} else {
			tmpIndex.push_back(bXMin);
			tmpIndex.push_back(bYMin);
			tmpIndex.push_back(bZMin);
			tmpSize.push_back(bXMax-bXMin+1);
			tmpSize.push_back(bYMax-bYMin+1);
			tmpSize.push_back(bZMax-bZMin+1);
		}
			
		bbSetOutputIndex(tmpIndex);
		bbSetOutputSize(tmpSize);
	} else {
		printf("bbtk warnning: bbtk:vtk:ImageBoundaries box, Input image (In) not initialized..\n");
	}
	printf("bbtk:vtk::ImageBoundaries::Process end\n");
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ImageBoundaries::bbUserSetDefaultValues()
{
	

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
   bbSetInputIn(NULL);
	bbSetInputLowerValue(0);
	bbSetInputUpperValue(5000);
  
	std::vector<int> tmpIndex;
	tmpIndex.push_back(0);
	tmpIndex.push_back(0);
	tmpIndex.push_back(0);

	std::vector<int> tmpSize;
	tmpSize.push_back(1);
	tmpSize.push_back(1);
	tmpSize.push_back(1);

	bbSetOutputIndex(tmpIndex);
	bbSetOutputSize(tmpSize);
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ImageBoundaries::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 

  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ImageBoundaries::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any
  
}
}
// EO namespace bbvtk


