/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkImageDataToString.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.5 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */


#ifdef _USE_VTK_

#include "bbstdToString.h"
#include "vtkImageData.h"
#include "bbvtkPackage.h"

typedef vtkImageData* vtkImageDataPtr;
typedef const vtkImageData* vtkImageDataConstPtr;

namespace bbtk
{
  //  BBTK_DEFINE_HUMAN_READABLE_TYPE_NAME(vtkImageDataPtr,"vtkImageDataPtr");
  //  BBTK_DEFINE_HUMAN_READABLE_TYPE_NAME(vtkImageDataConstPtr,"vtkImageDataConstPtr");
}

namespace bbstd
{
  //====================================================================
  BBTK_BLACK_BOX_TEMPLATE_IMPLEMENTATION(ToString,
					 bbtk::AtomicBlackBox);
  //====================================================================
  
  
  //====================================================================
  template <> void ToString<vtkImageData*> ::DoIt()
  {
    vtkImageData* im = bbGetInputIn();
    if (im==0) 
      {
	bbSetOutputOut("NULL");
	return;
      }
    int dim[3];
    im->GetDimensions(dim);
    
    std::ostringstream str;
    str << "vtkImageData ["
	<< dim[0] << "," 
	<< dim[1] << "," 
	<< dim[2] << "]"; 
    
    bbSetOutputOut( str.str() ); //bbGetInputIn()->GetInfoString() );
  }
  //====================================================================
}


using namespace bbstd;
namespace bbvtk
{
  //====================================================================
  // Add the specialized adaptors to the package
  BBTK_ADD_TEMPLATE_BLACK_BOX_TO_PACKAGE(vtk,ToString,vtkImageDataPtr);
}


#endif // _USE_VTK_
