/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Don't edit this file. This file is generated from xml description..
//=====
#include "bbvtkImageToPlainText.h"
#include "bbvtkPackage.h"

namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,ImageToPlainText)
BBTK_BLACK_BOX_IMPLEMENTATION(ImageToPlainText,bbtk::AtomicBlackBox);
//=====
// Don't edit this file. This file is generated from xml description..
//=====
void ImageToPlainText::Process()
{

// THE MAIN PROCESSING METHOD BODY
//   Here we simply set the input 'In' value to the output 'Out'
//   And print out the output value
// INPUT/OUTPUT ACCESSORS ARE OF THE FORM :
//    void bbSet{Input|Output}NAME(const TYPE&)
//    const TYPE& bbGet{Input|Output}NAME() const
//    Where :
//    * NAME is the name of the input/output
//      (the one provided in the attribute 'name' of the tag 'input')
//    * TYPE is the C++ type of the input/output
//      (the one provided in the attribute 'type' of the tag 'input')
if (bbGetInputIn() == NULL || bbGetInputInPath().size() == 0)
{
	std::cout << "Set In and InPath" << std::endl;
	return;
}

ejecutar(bbGetInputInPath(), bbGetInputIn());

}
//=====
// Don't edit this file. This file is generated from xml description..
//=====
void ImageToPlainText::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX
//    Here we initialize the input 'In' to 0
	std::string vacio = "";
	bbSetInputInPath(vacio);
   bbSetInputIn(NULL);

}
//=====
// Don't edit this file. This file is generated from xml description..
//=====
void ImageToPlainText::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should allocate the internal/output pointers
//    if any


}
//=====
// Don't edit this file. This file is generated from xml description..
//=====
void ImageToPlainText::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should desallocate the internal/output pointers
//    if any

}

void ImageToPlainText::ejecutar(std::string path, vtkImageData* image)
{
	int ext[6];
    std::ofstream outFile;
    outFile.open(path.data(), std::ios::out);
    image->GetExtent(ext);
    if (outFile)
    {
    	outFile << (ext[1]-ext[0]+1) << std::endl;
    	std::cout << (ext[1]-ext[0]+1) << std::endl;
    	outFile << (ext[3]-ext[2]+1) << std::endl;
    	std::cout << (ext[3]-ext[2]+1) << std::endl;
    	outFile << (ext[5]-ext[4]+1) << std::endl;
    	std::cout << (ext[5]-ext[4]+1) << std::endl;

    	for (int i=ext[0]; i<=ext[1]; i++)
    	{
    		for (int j=ext[2]; j<=ext[3]; j++)
    		{
    			for (int k=ext[4]; k<=ext[5]; k++)
    			{
    				double valor = lector.getPixelValue(i,j,k, image);
    				if (valor > 0)
    				{
    					outFile << "1";
    					//std::cout << "1";
    				}
    				else
    				{
    					outFile << "0";
    					//std::cout << "0";
    				}
    			}
    		}
    	}
    	outFile.close();
    }
    else
    {
    	std::cout << "No pudo escribir en " << path << std::endl;
    }
}

}
// EO namespace bbvtk


