/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbvtkImageVtkProperties.h"
#include "bbvtkPackage.h"
namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,ImageVtkProperties)
BBTK_BLACK_BOX_IMPLEMENTATION(ImageVtkProperties,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ImageVtkProperties::Process()
{
	unsigned int dim;
	int ext[6];
	double spc[3];
	double range[2];
	std::string nametype;
	int numberoOfComponents;
	std::vector<int> vsize;
	std::vector<float> vspacing;
	std::vector<float> vrange;

	if ( bbGetInputIn() ){
		bbGetInputIn()->Update();
		
		bbGetInputIn()->GetWholeExtent(ext);
		vsize.push_back(ext[1]-ext[0]+1);
		vsize.push_back(ext[3]-ext[2]+1);
		vsize.push_back(ext[5]-ext[4]+1);
		
		dim = 0;
		if (vsize[0]>1) dim++;
		if (vsize[1]>1) dim++;
		if (vsize[2]>1) dim++;
		
		bbGetInputIn()->GetScalarRange(range);
		numberoOfComponents=bbGetInputIn()->GetNumberOfScalarComponents();
	
		bbGetInputIn()->GetSpacing(spc);
		for (unsigned int i=0;i<dim;++i) 
			vspacing.push_back((float)spc[i]);

		vrange.push_back((float)range[0]);
		vrange.push_back((float)range[1]);

		if (bbGetInputIn()->GetScalarType()==VTK_BIT)			nametype="VTK_BIT";  		// 1
		if (bbGetInputIn()->GetScalarType()==VTK_CHAR)			nametype="VTK_CHAR"; 		// 2
		if (bbGetInputIn()->GetScalarType()==VTK_SIGNED_CHAR)		nametype="VTK_SIGNED_CHAR";  	// 15
		if (bbGetInputIn()->GetScalarType()==VTK_UNSIGNED_CHAR)		nametype="VTK_UNSIGNED_CHAR";	// 3
		if (bbGetInputIn()->GetScalarType()==VTK_SHORT)			nametype="VTK_SHORT"; 		// 4
		if (bbGetInputIn()->GetScalarType()==VTK_UNSIGNED_SHORT)	nametype="VTK_UNSIGNED_SHORT";  // 5
		if (bbGetInputIn()->GetScalarType()==VTK_INT)			nametype="VTK_INT";             // 6
		if (bbGetInputIn()->GetScalarType()==VTK_UNSIGNED_INT)		nametype="VTK_UNSIGNED_INT";    // 7
		if (bbGetInputIn()->GetScalarType()==VTK_LONG)			nametype="VTK_LONG";            // 8  
		if (bbGetInputIn()->GetScalarType()==VTK_UNSIGNED_LONG)		nametype="VTK_UNSIGNED_LONG";   // 9
		if (bbGetInputIn()->GetScalarType()==VTK_FLOAT)			nametype="VTK_FLOAT";           // 10
		if (bbGetInputIn()->GetScalarType()==VTK_DOUBLE)		nametype="VTK_DOUBLE";          // 11
	} else {	
		dim					= 0;		
		numberoOfComponents	= 0;
		vsize.push_back(0);
		vsize.push_back(0);
		vsize.push_back(0);
		vspacing.push_back(0);
		vspacing.push_back(0);
		vspacing.push_back(0);
		vrange.push_back(0);
		vrange.push_back(0);
		nametype			= "VOID";				
	}	
	bbSetOutputDimension( dim );
	bbSetOutputSize( vsize );
	bbSetOutputSpacing( vspacing );
	bbSetOutputMinMax( vrange );
	bbSetOutputTypeName( nametype );
	bbSetOutputComponents( numberoOfComponents );
	
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ImageVtkProperties::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
//    Here we initialize the input 'In' to 0
//   bbSetInputIn(0);
  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ImageVtkProperties::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 

  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ImageVtkProperties::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any
  
}
}
// EO namespace bbvtk


