//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbvtkInversCrop.h"
#include "bbvtkPackage.h"
namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,InversCrop)
BBTK_BLACK_BOX_IMPLEMENTATION(InversCrop,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void InversCrop::Process()
{

// THE MAIN PROCESSING METHOD BODY
//   Here we simply set the input 'In' value to the output 'Out'
//   And print out the output value
// INPUT/OUTPUT ACCESSORS ARE OF THE FORM :
//    void bbSet{Input|Output}NAME(const TYPE&)
//    const TYPE& bbGet{Input|Output}NAME() const 
//    Where :
//    * NAME is the name of the input/output
//      (the one provided in the attribute 'name' of the tag 'input')
//    * TYPE is the C++ type of the input/output
//      (the one provided in the attribute 'type' of the tag 'input')

    if ((bbGetInputImageFix()!=NULL) && (bbGetInputImageMove()!=NULL) )
    {
printf("EED InversCrop::Process ScalarType %d  %d \n", bbGetInputImageFix()->GetScalarType(), bbGetInputImageMove()->GetScalarType() );
     if ( bbGetInputImageFix()->GetScalarType()==bbGetInputImageMove()->GetScalarType() ) 
     {
        // Creating Image
	int dim[3];
	int ext[6];
	
	bbGetInputImageFix()->GetWholeExtent(ext);
	dim[0]= ext[1]-ext[0]+1;
	dim[1]= ext[3]-ext[2]+1;
	dim[2]= ext[5]-ext[4]+1;
		
	_imageoutput = vtkImageData::New();
	_imageoutput->Initialize();
	_imageoutput->SetScalarType( bbGetInputImageFix()->GetScalarType() );
	_imageoutput->SetSpacing( bbGetInputImageFix()->GetSpacing() );
	_imageoutput->SetDimensions(  dim[0], dim[1], dim[2] );
	_imageoutput->AllocateScalars();

        // Duplicating Fix Image
	long sizeimage = dim[0]*dim[1]*dim[2]*bbGetInputImageFix()->GetScalarSize(); 	
	memcpy( _imageoutput->GetScalarPointer() , bbGetInputImageFix()->GetScalarPointer() , sizeimage);

	// Copy the Move Image
	int j,k; 
	int px,py,pz;

	bbGetInputImageMove()->GetWholeExtent(ext);
	int dimMoveX = ext[1]-ext[0]+1;
	int dimMoveY = ext[3]-ext[2]+1;
	int dimMoveZ = ext[5]-ext[4]+1;

        int spxM=0;  // start px MoveImage
        int sizeXM=0;  // sizeX MoveImage

	px=bbGetInputOrigin()[0];
        spxM=0;
        if (px<=0)
	{ 
	   spxM=px*(-1);
	   px=0;
	}
	sizeXM = dimMoveX-spxM;
	if (px+sizeXM>=dim[0]) sizeXM=dim[0]-px;

	sizeXM=sizeXM*bbGetInputImageFix()->GetScalarSize();
	for (k=0; k<dimMoveZ; k++)
	{
	   for (j=0; j<dimMoveY; j++)
	   {
                py=j+bbGetInputOrigin()[1];
		pz=k+bbGetInputOrigin()[2];
		
		if ( (py<dim[1]) && (pz<dim[2]) &&
 	             (py>=0)    && (pz>=0)	&&
		     (sizeXM>0) ) 
		{
			memcpy( _imageoutput->GetScalarPointer(px,py,pz) , bbGetInputImageMove()->GetScalarPointer(spxM,j,k) , sizeXM );
		}

	   } // for j
	} // for k
        _imageoutput->Modified();
      } // If Image Fixe Move the same GetScalarType
        else {
           printf ("ERROR: InversCrop  both ImageFixe and ImageMove need the same format.\n");
      }  
    } // If Image Fixe Move != NULL
     else {
        printf ("ERROR: InversCrop  need ImageFixe and ImageMove to run.\n");
    } 
    bbSetOutputOut(_imageoutput);
}

//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void InversCrop::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
//    Here we initialize the input 'In' to 0
   bbSetInputImageFix(NULL);
   bbSetInputImageMove(NULL);

   std::vector<int> origin;
   origin.push_back(0);
   origin.push_back(0);
   origin.push_back(0);
   bbSetInputOrigin(origin);
   
   _imageoutput=NULL;
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void InversCrop::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 

  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void InversCrop::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any
  
}
}
// EO namespace bbvtk


