/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkMIPCreator.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.12 $
=========================================================================*/

/**
 *  \file
 *  \brief
 */

#ifdef _USE_VTK_

#include <vtkVolumeProperty.h>
#include <vtkPiecewiseFunction.h>

#include "bbvtkMIPCreator.h"
#include "bbvtkPackage.h"

namespace bbvtk
{
   BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,MIPCreator)
   BBTK_BLACK_BOX_IMPLEMENTATION(MIPCreator,bbtk::AtomicBlackBox);

	//---------------------------------------------------------------------
   void MIPCreator::bbUserSetDefaultValues()
   {



       std::vector<double> opaValues;
       std::vector<double> denPoints;
       opaValues.push_back(0.0);
       opaValues.push_back(1.0);
       bbSetInputDensityPoints(denPoints);
       bbSetInputOpacityValues(opaValues);
       bbSetInputMinColorWindow(0.0);
       bbSetInputMaxColorWindow(255.0);

       opacityTransferFunction = vtkPiecewiseFunction::New();
       grayTransferFunction = vtkPiecewiseFunction::New();

	   mCast	= NULL;
	   mMIP		= NULL;
	   mMapper	= NULL;
	   mVolume	= NULL;


   }
	//---------------------------------------------------------------------
   void MIPCreator::bbUserInitializeProcessing()
   {


    // Create the pipeline
    mCast = vtkImageShiftScale::New();
    mCast->SetOutputScalarTypeToUnsignedChar();
    mCast->ClampOverflowOn();


}

//---------------------------------------------------------------------
   void MIPCreator::bbUserFinalizeProcessing()
   {
	   if (mCast!=NULL)
	   {
		   mCast->Delete();
		   mCast=NULL;
	   }

	   if (mMIP!=NULL)
	   {
		   mMIP->Delete();
		   mMIP=NULL;
	   }

	   if (mMapper!=NULL)
	   {
		   mMapper->Delete();
		   mMapper=NULL;
	   }

	   if (mVolume!=NULL)
	   {
		   mVolume->Delete();
		   mVolume=NULL;
	   }
   }
//---------------------------------------------------------------------

   void MIPCreator::Process()
   {



        double ranges[2];
        vtkImageData *image =  bbGetInputIn();
        image->Update();
        image->GetScalarRange(ranges);

	   scale = 255/(ranges[1]/100);

       mCast->SetInput( bbGetInputIn() );
       mCast->SetScale( scale / 100.0 );
     //mCast->SetShift( -bbGetInputShift() );









     DensityPoints = bbGetInputDensityPoints();

     //We assign by default the values of density by regarding at range from the image
     if(DensityPoints.size()==0)
     {
            DensityPoints.push_back(ranges[0]);
            DensityPoints.push_back(ranges[1]);
     }


     OpacityValues = bbGetInputOpacityValues();

     while(DensityPoints.size()>OpacityValues.size())
     {
         OpacityValues.push_back(1.0);
     }



      double factor = scale/ 100.0 ;

       double minCF = bbGetInputMinColorWindow();
       double maxCF = bbGetInputMaxColorWindow();

       grayTransferFunction->AddSegment( minCF , 0.0 , maxCF , 1.0 );




        for(int i =0; i< DensityPoints.size(); i++)
        {
         cout<<"MIPCreator::Process::dPoint"<<i<<"::"<<DensityPoints.at(i)<<endl;
         cout<<"MIPCreator::Process::oPoint"<<i<<"::"<<OpacityValues.at(i)<<endl;

            opacityTransferFunction->AddPoint(DensityPoints.at(i)*factor, OpacityValues.at(i));
        }
	   //opacityTransferFunction = vtkPiecewiseFunction::New();
//	   opacityTransferFunction->AddPoint(   0 ,    0.0/100.0 );
//	   opacityTransferFunction->AddPoint(  85 ,    2.0/100.0 );
//	   opacityTransferFunction->AddPoint( 160 ,   25.0/100.0 );
//	   opacityTransferFunction->AddPoint( 210 ,   50.0/100.0 );
//	   opacityTransferFunction->AddPoint( 255 ,   90.0/100.0 );



     	   // Create a set of properties for mip
	   vtkVolumeProperty *mipProperty;
	   mipProperty = vtkVolumeProperty::New();
	   mipProperty->SetScalarOpacity( opacityTransferFunction );
	   mipProperty->SetColor( grayTransferFunction );

//	   mipProperty->SetInterpolationTypeToLinear();
	   mipProperty->SetInterpolationTypeToNearest();

//	   mipProperty->ShadeOff();
	   mipProperty->ShadeOn();

//	   mipProperty->SetAmbient(0.9);
//	   mipProperty->SetDiffuse(0.9);
//	   mipProperty->SetSpecular(0.9);





        mMIP = vtkVolumeRayCastMIPFunction::New();
        mMIP->SetMaximizeMethodToScalarValue();

        mMapper = vtkVolumeRayCastMapper::New();
        mMapper->SetVolumeRayCastFunction(mMIP);
        mMapper->SetInput(mCast->GetOutput()); // (smoother.GetOutput())

        mVolume = vtkVolume::New();
        mVolume->SetMapper(mMapper);
        mVolume->SetProperty( mipProperty );



        mMapper->Update();

      bbSetOutputOut(mVolume);
     //     mVolume->GetProperty()->SetColor( bbGetInputColour()[0],  bbGetInputColour()[1], bbGetInputColour()[2] );
     //     mVolume->GetProperty()->SetOpacity( bbGetInputOpacity() );

   }
}//namespace bbtk

#endif // _USE_VTK_

