/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la Sant)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbvtkMagnitud.h"
#include "bbvtkPackage.h"
namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,Magnitud)
BBTK_BLACK_BOX_IMPLEMENTATION(Magnitud,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void Magnitud::Process()
{

// THE MAIN PROCESSING METHOD BODY
//   Here we simply set the input 'In' value to the output 'Out'
//   And print out the output value
// INPUT/OUTPUT ACCESSORS ARE OF THE FORM :
//    void bbSet{Input|Output}NAME(const TYPE&)
//    const TYPE& bbGet{Input|Output}NAME() const 
//    Where :
//    * NAME is the name of the input/output
//      (the one provided in the attribute 'name' of the tag 'input')
//    * TYPE is the C++ type of the input/output
//      (the one provided in the attribute 'type' of the tag 'input')

// ---------- 
 if (bbGetInputIn()!=NULL) {
   vGreenToRedLut->SetHueRange(0.6667,0.0);
   vGreenToRedLut->Build();
  
  //Input Data
   vVecMagnitude->SetInput(bbGetInputIn());
   vVecMagnitude->NormalizeOff();
   vVecMagnitude->Update();
   vVecMagnitude->GetOutput()->GetScalarRange( range1 );
   vVecMagnitude->Update();
   
   //Glyph
   vMaskPoint->SetInput(bbGetInputIn());
   vMaskPoint->SetOnRatio(100);
   vMaskPoint->Update();
   vMaskPoint->RandomModeOn();
   
   vGlyph->SetInput(vMaskPoint->GetOutput());
   vGlyph->SetSource(cone->GetOutput());
   vGlyph->SetScaleModeToScaleByVector();
   vGlyph->SetColorModeToColorByVector();
   vGlyph->SetScaleFactor(0.20);
   vGlyphMapper->SetInput( vGlyph->GetOutput() );
   step = (range1[1]-range1[0])/10;
      
   //Contour
   dRangeColorForMultipleContourVelocity[0]=0;
   dRangeColorForMultipleContourVelocity[1]=1;
   dRangeColorForGlyphVelocity[0]=0;
   dRangeColorForGlyphVelocity[1]=1;
   vMultipleContourVelocity->SetInput((vtkDataSet *) vVecMagnitude->GetOutput()); 
   
   index = 0;
   double h;
   step = (range1[1]-range1[0])/10;

   for( h=range1[0]; h<range1[1]; h+=step )
   {
      vMultipleContourVelocity->SetValue(index, h);
      index+=1;
   }
   
   vMultipleContourMapper->SetInput( vMultipleContourVelocity->GetOutput() );
   vMultipleContourMapper->SetScalarRange( range1 );
   vMultipleContourMapper->SetLookupTable( vGreenToRedLut );
   vMultipleContourMapper->Update();
   vMultipleContourActor->SetMapper( vMultipleContourMapper );
   vMultipleContourActor->GetProperty()->SetOpacity(0.4);

   //Glyph Mapper
   vGlyphMapper->SetLookupTable(vGreenToRedLut);
   vGlyphMapper->SetScalarRange(range1);
   vGlyphMapper->ImmediateModeRenderingOn();
 
   //Outline Grid
   vOutlineGrid->SetInput( bbGetInputIn() );
   vOutlineMapper->SetInput(vOutlineGrid->GetOutput());
   
   //Outline Grid Actor
   vOutlineActor->SetMapper(vOutlineMapper);
 
   //Glyph Actor
   vGlyphActor->SetMapper( vGlyphMapper ); 
   vGlyphActor->GetProperty()->SetOpacity(0); 
  
   //The Velocity Bar - Indicator (It's Actor is a vtkProper)
   vScalarBarActor->SetLookupTable (vMultipleContourMapper->GetLookupTable());
   vScalarBarActor->SetTitle ("Velocity");
   vScalarBarActor->GetPositionCoordinate()->SetCoordinateSystemToNormalizedViewport();
   vScalarBarActor->GetPositionCoordinate()->SetValue( 0.85, 0.25);
   vScalarBarActor->SetOrientationToVertical();
   vScalarBarActor->SetWidth (0.1);
   vScalarBarActor->SetHeight (0.6);
   vScalarBarActor->GetProperty()->SetOpacity(1); // 1 to Show - 0 to Hide
   
   ///////////////////////////////////////////////////////////////////////////////////////////////////
   //Start: Change values by the user
   ///////////////////////////////////////////////////////////////////////////////////////////////////
   //Glyph Mask
   vMaskPoint->SetOnRatio( bbGetInputMRatio());
   vMaskPoint->Update();

   //Glyph Opacity
   vGlyphActor->GetProperty()->SetOpacity( bbGetInputOpactity()/100 );
   vGlyph->SetScaleFactor(vGlyph->GetScaleFactor()-0.1);
   vGlyph->Update();
   vGlyph->SetScaleFactor(vGlyph->GetScaleFactor()+0.1);
   vGlyph->Update();
   if( (bbGetInputScale()/100)<0 ) 
      bbSetInputScale(0);
   if( (bbGetInputScale()/100)>1 ) 
      bbSetInputScale(1);
   
   //vGlyph->SetScaleFactor(dScale);
   vGlyph->SetScaleFactor( bbGetInputScale()/100 );
   vGlyph->Update();

   //Set Glyph and Contour Colour Range
   vVecMagnitude->GetOutput()->GetScalarRange( range1 );
   dRangeColorForGlyphVelocity[0] = bbGetInputValInf()/100;
   dRangeColorForGlyphVelocity[1] = bbGetInputValSup()/100;
   dRangeColorForMultipleContourVelocity[0] = bbGetInputValInf()/100;
   dRangeColorForMultipleContourVelocity[1] = bbGetInputValSup()/100;
   double dTailleInterval=range1[1]-range1[0];
   
   range1[1]=range1[0]+dTailleInterval*(bbGetInputValSup()/100);
   range1[0]=range1[0]+dTailleInterval*(bbGetInputValInf()/100);
   
   vGlyphMapper->SetScalarRange( range1 );
   vMultipleContourMapper->SetScalarRange( range1 );

   if( bbGetInputOpactity()/100<0 ) 
      bbSetInputOpactity(0);
   if( bbGetInputOpactity()/100>1 ) 
      bbSetInputOpactity(1);

   //Set Contour Opacity
   vMultipleContourActor->GetProperty()->SetOpacity( bbGetInputOpactity()/100 );
   vMultipleContourVelocity->SetNumberOfContours(vMultipleContourVelocity->GetNumberOfContours()+1);
   vMultipleContourVelocity->Update();
   vMultipleContourVelocity->SetNumberOfContours(vMultipleContourVelocity->GetNumberOfContours()-1);
   vMultipleContourVelocity->Update();

   //Set The Number of Contours
   if( bbGetInputContour()<1) 
      bbSetInputContour(1);

   step=(range1[1]-range1[0])/bbGetInputContour();
   index=0;
   for( h=range1[0]; h<range1[1]; h+=step)
   {
      vMultipleContourVelocity->SetValue(index, h);
     index+=1;
   }
   ///////////////////////////////////////////////////////////////////////////////////////////////////
   //End: Change values by the user
   ///////////////////////////////////////////////////////////////////////////////////////////////////
   //The Plane Widget
   vPlaneWidget->SetInput(bbGetInputIn());
   vPlaneWidget->NormalToXAxisOn();
   vPlaneWidget->NormalToZAxisOn();
   vPlaneWidget->SetResolution(1);
   vPlaneWidget->SetRepresentationToOutline();
   //vPlaneWidget->SetInteractor(vIren);
   vPlaneWidget->SetPlaceFactor(1); //dfini zoom initial
   vPlaneWidget->PlaceWidget();
   vPlaneWidget->On();

   vPlaneWidget->GetOrigin(p0);
   vPlaneWidget->GetCenter(c); //These is from Execute Method
   vPlaneWidget->GetNormal(n);
   vPlaneWidget->GetPoint1(p1);
   vPlaneWidget->GetPoint2(p2);

   c[0] = c[0]+ bbGetInputMoveX();
   c[1] = c[1]+ bbGetInputMoveY();
   c[2] = c[2]+ bbGetInputMoveZ();

   vPlanSource->SetResolution( sizeIma-1,  sizeIma-1);
   vPlanSource->SetOrigin( p0 );
   vPlanSource->SetPoint1( p1 );
   vPlanSource->SetPoint2( p2 );
   vPlanSource->Update( );
   vPlanSource->SetNormal( n[ 0 ], n[ 1 ], n[ 2 ] );
   vPlanSource->Update( );
   vPlanSource->SetCenter( c );
   vPlanSource->Update( );
   
   vDiskSourceEED->SetInnerRadius (0);
   vDiskSourceEED->SetOuterRadius (10);
   vDiskSourceEED->SetRadialResolution (20);
   vDiskSourceEED->SetCircumferentialResolution (20);

   //Stream Lines
   vPointWidget->SetInput( bbGetInputIn() );
   vPointWidget->AllOff();
   vPointWidget->PlaceWidget();
   //vPointWidget->SetInteractor(vIren);
   vPointWidget->On();
   //vPointWidget->GetPolyData(point);
   vPointWidget->GetPolyData(point);
   source->SetNumberOfPoints(500);
   /*
   tempc = bbGetInputPlaneCenterSL();
   slCenter[0] = tempc[0];
   slCenter[1] = tempc[1];
   slCenter[2] = tempc[2];
   source->SetCenter(  slCenter );
   */
   source->SetCenter(  c );
   source->SetRadius(5.0);
   
   streamer->SetInput( bbGetInputIn() );
   streamer->SetSource(source->GetOutput());
   streamer->SetIntegratorTypeToRungeKutta45();
   streamer->SetMaximumPropagation(500000);
//EED    streamer->SetMaximumPropagationUnitToTimeUnit ();
   streamer->SetInitialIntegrationStep (0.001);
//EED    streamer->SetInitialIntegrationStepUnitToCellLengthUnit();
   streamer->SetIntegrationDirectionToBoth();
//EED   streamer->ComputeVorticityOn ();
   streamer->Update();

   rf->SetInput(streamer->GetOutput());
   rf->SetRadius(.5);
   rf->SetNumberOfSides(12);
   rf->SetVaryRadiusToVaryRadiusOff();
   
   streamer->GetOutput()->GetScalarRange( range );
   streamMapper2->SetInput(rf->GetOutput());
   streamMapper2->SetLookupTable(vGreenToRedLut);
   //vStreamlineActor2->SetMapper( streamMapper2 );
   
   //////////////////////////////////////////////////////////////////////////////////////
   //Start: Part of the Execute Method
   //////////////////////////////////////////////////////////////////////////////////////
   nx=n[0];
   ny=n[1];
   nz=n[2];
   alfa = atan2(ny,nx) * 180.0 / 3.1416;
   beta = atan2( nz, sqrt( nx*nx + ny*ny )  ) * 180.0 / 3.1416;
   transformEED->Identity();  
   transformEED->Translate(c);
   transformEED->RotateWXYZ(alfa,0,0,1);
   transformEED->RotateWXYZ(-beta,0,1,0);
   transformEED->RotateWXYZ(90,0,1,0);
   transformEED->Update();
   //////////////////////////////////////////////////////////////////////////////////////
   //End: Part of the Execute Method
   //////////////////////////////////////////////////////////////////////////////////////

   vtransformpolydatafilter->SetInput( vDiskSourceEED->GetOutput() );
   vtransformpolydatafilter->SetTransform( transformEED );
   vtransformpolydatafilter->Update();
   
   vProbeslices->SetInput( ( vtkDataSet* )vtransformpolydatafilter->GetOutput());
   vProbeslices->SetSource( bbGetInputIn() ); 
   vProbeslices->Update( );

   vGlyphFlowPlane->SetInput(vProbeslices->GetOutput());
   vGlyphFlowPlane->SetSource(vArrowSource->GetOutput());
   vGlyphFlowPlane->SetScaleModeToScaleByVector();
   vGlyphFlowPlane->SetColorModeToColorByVector();
   vGlyphFlowPlane->SetScaleFactor(0.2);
   vGlyphFlowPlane->Update();

   vProbeslicesFlowWidget->SetInput( ( vtkDataSet* )vPlanSource->GetOutput());
   vProbeslicesFlowWidget->SetSource( vVecMagnitude->GetOutput() ); 
   vProbeslicesFlowWidget->Update( );
      
   vVecMagnitude->GetOutput()->GetScalarRange( range );

   vAppendDataForFlowWidgetVisualisation->AddInput(vGlyphFlowPlane->GetOutput());
   vAppendDataForFlowWidgetVisualisation->AddInput(vProbeslicesFlowWidget->GetPolyDataOutput());

   vSliceMapper->SetInput( vAppendDataForFlowWidgetVisualisation->GetOutput());
   vSliceMapper->SetScalarRange( range );
   vSliceMapper->SetLookupTable( vGreenToRedLut );
   
   vSliceActor->SetMapper( vSliceMapper );

   if(bbGetInputShowPlane() == 1)
      vPlaneWidget->On();
   else if(bbGetInputShowPlane() == 0)
      vPlaneWidget->Off();

   vSliceActor->GetProperty()->SetOpacity( bbGetInputShowPlane() );

   exporter->SetInputConnection( vMultipleContourMapper->GetOutputPort() );
   exporter->ImageLowerLeftOn();

   bbSetOutputOut1( vSliceActor );
   bbSetOutputOut2( vGlyphActor );
   bbSetOutputOut3( vOutlineActor );
   bbSetOutputOut4( vMultipleContourActor );
   //bbSetOutputOut5( vScalarBarActor );
   if(bbGetInputShowStream() == 1)
      vStreamlineActor2->SetMapper( streamMapper2 );
   else 
      vStreamlineActor2->SetMapper( NULL );

   bbSetOutputOut5( vStreamlineActor2 );
   //bbSetOutputOut5( vStreamlineActor2 );
   //bbSetOutputOutExport( exporter );
   //temp->GetData( (vtkInformation*) vMultipleContourVelocity->GetOutput() );
   //temp->GetData( vMultipleContourMapper->GetOutput() );
   //bbSetOutputOutTest( temp );


 } // if

} // process



//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void Magnitud::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
//    Here we initialize the input 'In' to 0
// --------- [
   bbSetInputIn(NULL);
   bbSetInputMoveX(0);
   bbSetInputMoveY(0);
   bbSetInputMoveZ(0);
   bbSetInputValSup(1);
   bbSetInputValInf(0);
   bbSetInputMRatio(100);
   bbSetInputOpactity(0.5);
   bbSetInputScale(0.2);
   bbSetInputContour(10);
   bbSetInputShowPlane(1);
   bbSetInputShowStream(0);
   //bbSetInputPlaneCenterSL();
// --------- ]  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void Magnitud::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 

// ---------- [
   cone = vtkArrowSource::New();
   exporter = vtkImageExport::New();
   point = vtkPolyData::New();
   rf = vtkTubeFilter::New();
   source = vtkPointSource::New();
   streamer = vtkStreamTracer::New();
   streamMapper2 = vtkPolyDataMapper::New();
   
   transformEED             = vtkTransform::New();
   vAppendDataForFlowWidgetVisualisation = vtkAppendPolyData::New();
   vArrowSource             = vtkArrowSource::New();
   vDiskSourceEED           = vtkDiskSource::New();
   vGlyph                   = vtkGlyph3D::New();
   vGlyphActor              = vtkActor::New();
   vGlyphFlowPlane          = vtkGlyph3D::New();
   vGlyphMapper             = vtkPolyDataMapper::New();
   vGreenToRedLut           = vtkLookupTable::New();
   vIren                    = vtkRenderWindowInteractor::New();
   vMaskPoint               = vtkMaskPoints::New();
   vMultipleContourActor    = vtkActor::New();
   vMultipleContourMapper   = vtkPolyDataMapper::New();
   vMultipleContourVelocity = vtkContourFilter::New();
   vOutlineActor            = vtkActor::New();
   vOutlineGrid             = vtkOutlineFilter::New();
   vOutlineMapper           = vtkPolyDataMapper::New();
   vPlanSource              = vtkPlaneSource::New();
   vPlaneWidget             = vtkPlaneWidget::New();
   vPointWidget             = vtkPointWidget::New();
   vProbeslices             = vtkProbeFilter::New();
   vProbeslicesFlowWidget   = vtkProbeFilter::New();
   vScalarBarActor          = vtkScalarBarActor::New();
   vSliceMapper             = vtkPolyDataMapper::New();
   vSliceActor              = vtkActor::New();
   vStreamlineActor2        = vtkActor::New();
   vtransformpolydatafilter = vtkTransformPolyDataFilter::New();
   vVecMagnitude            = vtkVectorNorm::New();

   temp                     = vtkImageData::New();

   sizeIma = SIZEPLANWIDGET;
// ---------- }  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void Magnitud::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any

/// \TODO delete everything no longer needed!
  
}
}
// EO namespace bbvtk


