/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkMarchingCubes.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.8 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */


#ifdef _USE_VTK_

#include "bbvtkMarchingCubes.h"
#include "bbvtkPackage.h"

namespace bbvtk
{

   BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,MarchingCubes)
   BBTK_BLACK_BOX_IMPLEMENTATION(MarchingCubes,bbtk::AtomicBlackBox);


	void MarchingCubes::Process()
	{
		bbGetVtkObject()->SetValue(0, bbGetInputValue() );
		if(bbGetInputComputeNormalsOn())
			bbGetVtkObject()->ComputeNormalsOn();
		else
			bbGetVtkObject()->ComputeNormalsOff();

		if(bbGetInputComputeScalarsOn())
			bbGetVtkObject()->ComputeScalarsOn();
		else
			bbGetVtkObject()->ComputeScalarsOff();
		bbGetVtkObject()->Update();		
	}
	
	//-----------------------------------------------------------------	
	void MarchingCubes::bbUserSetDefaultValues()
	{
		 BBTK_VTK_SET_DEFAULT_VALUES();
		bbSetInputValue(400);
		bbSetInputComputeNormalsOn(true);
		bbSetInputComputeScalarsOn(true);
	}
	
	//-----------------------------------------------------------------	
	void MarchingCubes::bbUserInitializeProcessing()
	{
		BBTK_VTK_INITIALIZE_PROCESSING();
	}
	
	//-----------------------------------------------------------------	
	void MarchingCubes::bbUserFinalizeProcessing()
	{
		BBTK_VTK_FINALIZE_PROCESSING();
	}	
	
	
} // EO namespace bbvtk


#endif //_USE_VTK_


