//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbvtkMeasureLength.h"
#include "bbvtkPackage.h"
namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,MeasureLength)
BBTK_BLACK_BOX_IMPLEMENTATION(MeasureLength,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void MeasureLength::Process()
{
	std::cout << "RaC MeasureLength::Process START"<< std::endl;

	_points = bbGetInputPoints();
	_image = bbGetInputImageData();

	double sumLength =0;
	if(_image != NULL && _points->GetNumberOfPoints()>1)
	{

		double spc[3];
		double origin[3];

		_image->GetSpacing(spc);
		_image->GetOrigin(origin);

		double* first;
		first = _points->GetPoint(0);

		double firstWorld[3];
		firstWorld[0] = first[0]*spc[0] + origin[0];
		firstWorld[1] = first[1]*spc[1] + origin[1];
		firstWorld[2] = first[2]*spc[2] + origin[2];



		for(int i = 1; i<_points->GetNumberOfPoints();i++)
		{
			double* second;
			second = _points->GetPoint(i);
			double secondWorld[3];
			secondWorld[0] = second[0]*spc[0] + origin[0];
			secondWorld[1] = second[1]*spc[1] + origin[1];
			secondWorld[2] = second[2]*spc[2] + origin[2];

			double XFactor = secondWorld[0]-firstWorld[0];
			double YFactor = secondWorld[1]-firstWorld[1];
			double ZFactor = secondWorld[2]-firstWorld[2];
			sumLength += XFactor*XFactor + YFactor*YFactor + ZFactor*ZFactor;

			firstWorld[0] = secondWorld[0];
			firstWorld[1] = secondWorld[1];
			firstWorld[2] = secondWorld[2];

		}
	}

	bbSetOutputLength(sumLength);

	std::cout << "RaC MeasureLength::Process END"<< std::endl;
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void MeasureLength::bbUserSetDefaultValues()
{
	bbSetOutputLength(0);
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void MeasureLength::bbUserInitializeProcessing()
{



  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void MeasureLength::bbUserFinalizeProcessing()
{


  
}
}
// EO namespace bbvtk


