/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkPiecewiseFunction.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.3 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */



#ifdef _USE_VTK_


#include "bbvtkPiecewiseFunction.h"
#include "bbvtkPackage.h"

namespace bbvtk
{


   BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,PiecewiseFunction)
   BBTK_BLACK_BOX_IMPLEMENTATION(PiecewiseFunction,bbtk::AtomicBlackBox);


	//---------------------------------------------------------------------
   void PiecewiseFunction::bbUserSetDefaultValues() 
   { 
     // Identity function
     std::vector<float> x,y;
     x.push_back(0);
     x.push_back(1);
     y.push_back(0);
     y.push_back(1);
     bbSetInputX(x);
     bbSetInputY(y);
	 bbSetOutputOut(0);
   }

	
	//---------------------------------------------------------------------
   void PiecewiseFunction::bbUserInitializeProcessing() 
   { 
     bbSetOutputOut(vtkPiecewiseFunction::New());
   }

	//---------------------------------------------------------------------
   void PiecewiseFunction::bbUserFinalizeProcessing() 
   { 
	   if (bbGetOutputOut()!=NULL)
	   {
		   bbGetOutputOut()->Delete();
		   bbSetOutputOut(0);
	   }
   }
//---------------------------------------------------------------------

   void PiecewiseFunction::Process()
   {
     if ( ( bbGetInputStatus("X") != bbtk::UPTODATE ) || 
	  ( bbGetInputStatus("Y") != bbtk::UPTODATE ) )
       {
	 if  ( bbGetInputX().size() != bbGetInputY().size() ) 
	   bbtkError(bbGetFullName()
		     <<" : input vectors X and Y do not have the same size"); 
	 if  ( bbGetInputX().size() < 2 ) 
	   bbtkError(bbGetFullName()
		     <<" : input vectors X and Y have a size < 2"); 
	 bbGetOutputOut()->RemoveAllPoints ();
	 //	 std::cout << bbGetInputX().size()<< ","<< bbGetInputY().size()<< std::endl;
	 std::vector<float>::const_iterator x,y;
	 std::vector<float> X = bbGetInputX(); 
	 std::vector<float> Y = bbGetInputY(); 
	 for (x = X.begin(), y = Y.begin();
	      x != X.end(),  y != Y.end();
	      ++x, ++y )
	   {
	     //     	     std::cout << *x << " -> " << *y << std::endl;
	     bbGetOutputOut()->AddPoint(*x,*y);
	   }
       }
   }

}//namespace bbtk

#endif // _USE_VTK_

