/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "bbvtkPolyDataReaderPlus.h"
#include "bbvtkPackage.h"
namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,PolyDataReaderPlus)
BBTK_BLACK_BOX_IMPLEMENTATION(PolyDataReaderPlus,bbtk::AtomicBlackBox);
void PolyDataReaderPlus::Process()
{

    std::cout << "[" << this << "]" << "PolyDataReaderPlus::Process()..." << std::endl;
	//Review the observers...

	if (!HasObserver(OBS_POST_READER_1) && bbGetInputInPostReadObs1() != NULL)
		AddObserver(OBS_POST_READER_1, bbGetInputInPostReadObs1());

	if (bbGetInputInPath().size()==0)
	{
		std::cout << "Set InPath." << std::endl;
		return;
	}

	//Read!
	if (!readed)
	{
		std::vector< std::string > partes = StringSplit(bbGetInputInPath(), ".");
		std::string extension = partes.at(partes.size()-1);

		std::cout << "Extension (vtk o vtp?) = " << extension << std::endl;

		if (extension.compare("vtk") == 0)
		{
			//vtkPolyDataReader* reader = vtkPolyDataReader::New();
			vtkGenericDataObjectReader* reader = vtkGenericDataObjectReader::New();
			reader->SetFileName(bbGetInputInPath().data());
			informacion = (vtkPolyData*)reader->GetOutput();
			reader->CloseVTKFile();
			vtkPolyData* old = bbGetOutputOut();  // old unused ? // JPR
			bbSetOutputOut(informacion);
			readed = true;
		}

		if (extension.compare("vtp") == 0)
		{
			vtkXMLPolyDataReader* reader = vtkXMLPolyDataReader::New();
			reader->SetFileName(bbGetInputInPath().data());
			informacion = reader->GetOutput();

			vtkPolyData* old = bbGetOutputOut();  // old unused ? // JPR
			bbSetOutputOut(informacion);
			readed = true;
		}
	}

	vtkActor *actor = (vtkActor*)bbGetOutputOutActor();
	vtkPolyDataMapper *mapper = vtkPolyDataMapper::New();

	mapper->SetInput(informacion);
	actor->SetMapper(mapper);

	bbSetOutputOutActor(actor);

	if (bbGetInputInColor().size()  >= 3)
	{
		actor->GetProperty()->SetColor(bbGetInputInColor()[0],bbGetInputInColor()[1],bbGetInputInColor()[2]);
	}
	else
	{
		actor->GetProperty()->SetColor(1,1,1);
	}
	actor->GetProperty()->SetOpacity(bbGetInputInOpacity()/100);

	//old->Delete();

	InvokeEvent(OBS_POST_READER_1, informacion);

	std::cout << "END [" << this << "]" << "PolyDataReaderPlus::Process()..." << std::endl;

}
void PolyDataReaderPlus::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX
//    Here we initialize the input 'In' to 0
	vtkPolyData* empty = vtkPolyData::New();
	vtkActor *actor = vtkActor::New();
    bbSetOutputOut(empty);
	bbSetInputInPostReadObs1(NULL);
	std::string nada = "";
	bbSetInputInPath(nada);
	bbSetOutputOutActor(actor);
	bbSetInputInOpacity(50);

	readed = false;

}
void PolyDataReaderPlus::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should allocate the internal/output pointers
//    if any


}
void PolyDataReaderPlus::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should desallocate the internal/output pointers
//    if any

}

}
// EO namespace bbvtk



