/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkPolyDataToActor.cxx,v $
  Language:  C++
  Date:      $Date: 2009/05/28 08:55:44 $
  Version:   $Revision: 1.15 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */


#ifdef _USE_VTK_

#include "vtkProperty.h"
#include "vtkLinearTransform.h"

#include "bbvtkPolyDataToActor.h"
#include "bbvtkPackage.h"

namespace bbvtk
{
   BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,PolyDataToActor)
   BBTK_BLACK_BOX_IMPLEMENTATION(PolyDataToActor,bbtk::AtomicBlackBox);

   void PolyDataToActor::bbUserSetDefaultValues() 
   { 
	   firsttime=true;
	   std::vector<double> colour;
	   colour.push_back(1.0);
	   colour.push_back(1.0);
	   colour.push_back(0.5);
	   bbSetInputColour(colour);

	   bbSetInputIn(NULL);
	   bbSetInputRenderer(NULL);
	   bbSetInputTransform(NULL);
	   bbSetInputOpacity(1);
	   bbSetInputRepresentation(2);
	   bbSetInputLineWidth(1);
	   bbSetInputScalarVisibility(false);

	   polydatamapper = NULL;
	   vtkactor       = NULL;
   }


	//---------------------------------------------------------------------
   void PolyDataToActor::bbUserInitializeProcessing() 
   { 	 
     polydatamapper = vtkPolyDataMapper::New();
     vtkactor       = vtkActor::New();

//     polydatamapper->SetInput(marchingcubes->GetOutput());
     vtkactor->SetMapper(polydatamapper);

     polydatamapper->ImmediateModeRenderingOn();
   }

	//---------------------------------------------------------------------
	void PolyDataToActor::bbUserFinalizeProcessing() 
	{ 
		if (polydatamapper!=NULL)
		{
			polydatamapper->Delete();
			polydatamapper=NULL;
		}
		if (vtkactor!=NULL)
		{
			vtkactor->Delete();
			vtkactor=NULL;
		}		
	}
	
	
//---------------------------------------------------------------------

   void PolyDataToActor::DoProcess()
   {	   
     polydatamapper->SetInput( bbGetInputIn() );
     
	 vtkactor->GetProperty()->SetRepresentation( bbGetInputRepresentation() );
	 vtkactor->GetProperty()->SetLineWidth( bbGetInputLineWidth() );
	   
     vtkactor->GetProperty()->SetColor( bbGetInputColour()[0],  
					bbGetInputColour()[1], 
					bbGetInputColour()[2] );
          
     vtkactor->GetProperty()->SetOpacity( bbGetInputOpacity() );
     
     if ( bbGetInputTransform()!=NULL )
     {
        vtkactor->SetUserTransform( bbGetInputTransform() );
     }

     bbSetOutputOut( vtkactor );

     // Interface Update
     if ((firsttime==true) && (bbGetInputRenderer()!=NULL ))
     {
       firsttime=false;
       bbGetInputRenderer()->AddActor( vtkactor );
     }  // firsttime

     if (bbGetInputScalarVisibility()==true )
     {
	     polydatamapper->ScalarVisibilityOn();
     } else {
	     polydatamapper->ScalarVisibilityOff();
     } // ScalarVisibility


   }



} // EO namespace bbtk

#endif //_USE_VTK_

