/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "bbvtkPolyDataWriterPlus.h"
#include "bbvtkPackage.h"
namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,PolyDataWriterPlus)
BBTK_BLACK_BOX_IMPLEMENTATION(PolyDataWriterPlus,bbtk::AtomicBlackBox);
void PolyDataWriterPlus::Process()
{
	std::cout << "[" << this << "]" << "PolyDataWriterPlus::Process()..." << std::endl;
	//Review the observers...

	if (!HasObserver(OBS_PRE_WRITER_1) && bbGetInputInPrePersistObs1() != NULL)
		AddObserver(OBS_PRE_WRITER_1, bbGetInputInPrePersistObs1());
 /// \TODO fix warning: NULL used in arithmetic // JPR
	if (!HasObserver(OBS_POST_WRITER_1) == NULL && bbGetInputInPostPersistObs1() != NULL)
		AddObserver(OBS_POST_WRITER_1, bbGetInputInPostPersistObs1());

	InvokeEvent(OBS_PRE_WRITER_1);

	if (bbGetInputInPath().size()==0)
	{
		std::cout << "Set InPath." << std::endl;
		return;
	}

	vtkPolyData* cosa;

	if (bbGetInputIn()==NULL)
	{
		if (bbGetInputIn2()==NULL)
		{
			std::cout << "Set In." << std::endl;
			return;
		}
		else
		{
			vtkProp3D* actor = bbGetInputIn2();
			vtkPolyDataMapper* mapper = ((vtkPolyDataMapper*)((vtkActor*)actor)->GetMapper());
			cosa = mapper->GetInput();
		}
	}
	else
	{
		cosa = bbGetInputIn();
	}

	std::string nuevo_nombre = guessName(bbGetInputInPath());


	vtkPolyData* entrada = cosa;
	std::cout << "Before writing" << std::endl;
	entrada->Print(std::cout);

	std::vector< std::string > partes = StringSplit(nuevo_nombre, ".");
	std::string extension = partes.at(partes.size()-1);

	std::cout << "Extension (vtk, vtp o stl?) => " << extension << std::endl;



	vtkDataSetSurfaceFilter* surfaceFilter = vtkDataSetSurfaceFilter::New();
	surfaceFilter->SetInput(entrada);
	surfaceFilter->Update();
	//vtkPolyData* polydata = surfaceFilter->GetOutput();
	entrada = surfaceFilter->GetOutput();

	if (extension.compare("vtk") == 0)
	{
		vtkPolyDataWriter* writer = vtkPolyDataWriter::New();
		writer->SetInput(entrada);
		writer->SetFileName(nuevo_nombre.data());
		writer->Write();
		writer->Delete();
	}

	if (extension.compare("vtp") == 0)
	{
		vtkXMLPolyDataWriter* writer = vtkXMLPolyDataWriter::New();
		writer->SetFileName ( nuevo_nombre.data() );
		writer->SetInput ( entrada );
		writer->Write();
		writer->Delete();
	}

	if (extension.compare("stl") == 0)
	{
		vtkSTLWriter* writer = vtkSTLWriter::New();
		writer->SetFileName ( nuevo_nombre.data() );
		writer->SetInput ( entrada );
		writer->Write();
		writer->Print(std::cout);
		writer->Delete();
	}


	std::cout << "Saving Ok!" << std::endl;

	InvokeEvent(OBS_POST_WRITER_1);
}
void PolyDataWriterPlus::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX
//    Here we initialize the input 'In' to 0
    bbSetInputIn(NULL);
	bbSetInputIn2(NULL);
	bbSetInputInPrePersistObs1(NULL);
	bbSetInputInPostPersistObs1(NULL);
	std::string nada = "";
	std::string prefixDefault = "Data";
	bbSetInputInPath(nada);
	bbSetInputInFilePrefix(prefixDefault);

}
void PolyDataWriterPlus::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should allocate the internal/output pointers
//    if any


}
void PolyDataWriterPlus::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should desallocate the internal/output pointers
//    if any
	RemoveAllObservers();

	if (bbGetInputInPrePersistObs1() != NULL && bbGetInputInPrePersistObs1()->GetReferenceCount() > 0)
		bbGetInputInPrePersistObs1()->SetReferenceCount(bbGetInputInPrePersistObs1()->GetReferenceCount()-1);
	if (bbGetInputInPostPersistObs1() != NULL)
		bbGetInputInPostPersistObs1()->SetReferenceCount(bbGetInputInPostPersistObs1()->GetReferenceCount()-1);
}
}
// EO namespace bbvtk


