/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Don't edit this file. This file is generated from xml description.. 
//===== 
#include "bbvtkRescaleSlopeIntercept.h"
#include "bbvtkPackage.h"


namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,RescaleSlopeIntercept)
BBTK_BLACK_BOX_IMPLEMENTATION(RescaleSlopeIntercept,bbtk::AtomicBlackBox);
//===== 
// Don't edit this file. This file is generated from xml description.. 
//===== 
void RescaleSlopeIntercept::Process()
{

// THE MAIN PROCESSING METHOD BODY
//   Here we simply set the input 'In' value to the output 'Out'
//   And print out the output value
// INPUT/OUTPUT ACCESSORS ARE OF THE FORM :
//    void bbSet{Input|Output}NAME(const TYPE&)
//    const TYPE& bbGet{Input|Output}NAME() const 
//    Where :
//    * NAME is the name of the input/output
//      (the one provided in the attribute 'name' of the tag 'input')
//    * TYPE is the C++ type of the input/output
//      (the one provided in the attribute 'type' of the tag 'input')
//    bbSetOutputOut( bbGetInputIn() );
//    std::cout << "Output value = " <<bbGetOutputOut() << std::endl;
  
	double range[2];
	double spc[3];
	int ext[6];
	double A=bbGetInputA();
	double B=bbGetInputB();
	
	if (bbGetInputIn()!=0)
	{
		if (bbGetInputOutputFormat()=="SAME")					outputformat = bbGetInputIn()->GetScalarType();
		else if (bbGetInputOutputFormat()=="VTK_BIT")			outputformat = VTK_BIT;   	   // 1
		else if (bbGetInputOutputFormat()=="VTK_CHAR")			outputformat = VTK_CHAR;  	   // 2
		else if (bbGetInputOutputFormat()=="VTK_SIGNED_CHAR")		outputformat = VTK_SIGNED_CHAR;    // 15
		else if (bbGetInputOutputFormat()=="VTK_UNSIGNED_CHAR")		outputformat = VTK_UNSIGNED_CHAR;  // 3
		else if (bbGetInputOutputFormat()=="VTK_SHORT") 		outputformat = VTK_SHORT; 	   // 4
		else if (bbGetInputOutputFormat()=="VTK_UNSIGNED_SHORT") 	outputformat = VTK_UNSIGNED_SHORT; // 5
		else if (bbGetInputOutputFormat()=="VTK_INT")			outputformat = VTK_INT;            // 6
		else if (bbGetInputOutputFormat()=="VTK_UNSIGNED_INT")		outputformat = VTK_UNSIGNED_INT;   // 7
		else if (bbGetInputOutputFormat()=="VTK_LONG")			outputformat = VTK_LONG;           // 8  
		else if (bbGetInputOutputFormat()=="VTK_UNSIGNED_LONG")		outputformat = VTK_UNSIGNED_LONG;  // 9
		else if (bbGetInputOutputFormat()=="VTK_FLOAT")			outputformat = VTK_FLOAT;          // 10
		else if (bbGetInputOutputFormat()=="VTK_DOUBLE")		outputformat = VTK_DOUBLE;         // 11 
		
		
		bbGetInputIn()->GetScalarRange(range);
		bbGetInputIn()->GetSpacing(spc);
		bbGetInputIn()->GetExtent( ext );				
		
		double range0plusrange1 = range[0]+range[1];
		double difrange			= range[1]-range[0];
		double newdifrange		= B-A;
		
		double shift;
		double scale;
		
		if (bbGetInputType()==0) // Rescale Slope/Intercept
		{ 
			//			newValue = value*A+B;
			scale = A;
			shift = B;
		} // if type 0
		
		if (bbGetInputType()==1) // Invert
		{ 
			//			newValue = value*(-1) + (range0plusrange1);
			scale=-1;
			shift=range0plusrange1;
		} // if type 1
		
		if (bbGetInputType()==2) // Redimension
		{ 
			//			newValue = ((value-range[0])/difrange)*newdifrange + A;
			scale=newdifrange/difrange;
			shift= A - (range[0]*newdifrange/difrange);
		} // if type 2
		
		if (bbGetInputType()==3) // Invert redimension
		{ 
			//			newValue = ((value*(-1)+range[1])/difrange)*newdifrange + A;
			scale=-newdifrange/difrange;
			shift= A + (range[1]*newdifrange/difrange);
		} // if type 3
		
		filter1->SetInput( bbGetInputIn() );
		filter1->SetOutputScalarType( VTK_DOUBLE );
		filter1->SetShift( 0 );
		filter1->SetScale( scale );
		
		filter2->SetInput( filter1->GetOutput() );
		filter2->SetOutputScalarType( outputformat );
		filter2->SetShift( shift );
		filter2->SetScale( 1 );
		
		mchange->SetInput( filter2->GetOutput() );
		mchange->SetExtentTranslation( -ext[0], -ext[2], -ext[4] );
		mchange->SetOutputSpacing (spc);
		mchange->Update();    //important
		bbSetOutputOut( mchange->GetOutput() );
	 	
	} else  {
		bbSetOutputOut( NULL );
	}		// if bbGetInputIn	
}
	
	
//===== 
// Don't edit this file. This file is generated from xml description.. 
//===== 
void RescaleSlopeIntercept::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
//    Here we initialize the input 'In' to 0
	bbSetInputIn(NULL);
	bbSetInputType(0);
	bbSetInputA(1);
	bbSetInputB(0);
	bbSetInputOutputFormat("SAME");

	filter1	= NULL;
	filter2	= NULL;
	mchange	= NULL;
}
//===== 
// Don't edit this file. This file is generated from xml description.. 
//===== 
void RescaleSlopeIntercept::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 

	filter1	= vtkImageShiftScale::New();
	filter2	= vtkImageShiftScale::New();
	mchange = vtkImageChangeInformation::New();

  
}
//===== 
// Don't edit this file. This file is generated from xml description.. 
//===== 
void RescaleSlopeIntercept::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any
	mchange->Delete();		
	filter1->Delete();
	filter2->Delete();
}
	
}
// EO namespace bbvtk


