/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkSegmentationConnectivity.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.8 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */

#ifdef _USE_VTK_

#include "bbvtkSegmentationConnectivity.h"
#include "bbvtkPackage.h"

namespace bbvtk
{
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,SegmentationConnectivity);
  BBTK_BLACK_BOX_IMPLEMENTATION(SegmentationConnectivity,
				bbtk::AtomicBlackBox);

// --------------------------------------------------------------

  void SegmentationConnectivity::bbUserSetDefaultValues() 
  { 
	  thresh2	= NULL;
	  cast2		= NULL;
	  connect2	= NULL;
	  cast4		= NULL;
		
	  bbSetInputIn(NULL);
	  std::vector<int> position;
	  position.push_back(0);
	  position.push_back(0);
	  position.push_back(0);
	  bbSetInputPositionXYZ(position);
	  std::vector<int> threshold;
	  threshold.push_back(0);
	  threshold.push_back(0);
	  bbSetInputThresholdMinMax(threshold);
	  bbSetOutputOut(NULL);
  }

// --------------------------------------------------------------
		
	void SegmentationConnectivity::bbUserInitializeProcessing()
	{
		thresh2 = vtkImageThreshold::New();
			thresh2->SetInValue(255);
			thresh2->SetOutputScalarTypeToUnsignedShort();
			thresh2->SetOutValue(0);
		cast2 = vtkImageCast::New();
			cast2->SetInput(thresh2->GetOutput());
			cast2->SetOutputScalarTypeToUnsignedChar();
		connect2 = vtkImageSeedConnectivity::New();
			connect2->SetInput(cast2->GetOutput());
			connect2->SetInputConnectValue(255);
			connect2->SetOutputConnectedValue(255);
			connect2->SetOutputUnconnectedValue(0);
		cast4 = vtkImageCast::New();
			cast4->SetInput(connect2->GetOutput());
			cast4->SetOutputScalarTypeToUnsignedShort();
	}

// --------------------------------------------------------------
		
  void SegmentationConnectivity::bbUserFinalizeProcessing() 
  { 
	  if (thresh2!=NULL)
	  {
		  thresh2->Delete();
		  thresh2=NULL;
	  }
	  if (cast2!=NULL)
	  {
		  cast2->Delete();
		  cast2=NULL;
	  }
	  if (connect2!=NULL)
	  {
		  connect2->Delete();
		  connect2=NULL;
	  }
	  if (cast4!=NULL)
	  {
		  cast4->Delete();
		  cast4=NULL;
	  }  
  }

// --------------------------------------------------------------
		
  void SegmentationConnectivity::DoProcess()
  {
    vtkImageData *imagedata = bbGetInputIn();
    imagedata->UpdateInformation();
    imagedata->SetUpdateExtent(imagedata->GetWholeExtent());
    imagedata->Update();
    thresh2->ThresholdBetween(3000, 3001);
    thresh2->SetInput(imagedata);
    thresh2->ThresholdBetween(bbGetInputThresholdMinMax()[0], bbGetInputThresholdMinMax()[1]);
    thresh2->Modified();
    thresh2->Update();
    cast2->Modified();
    cast2->Update();
    connect2->RemoveAllSeeds ();
	  
	int x = bbGetInputPositionXYZ()[0];
	int y = bbGetInputPositionXYZ()[1];
	int z = bbGetInputPositionXYZ()[2];

	  int ext[6];
	  imagedata->GetWholeExtent(ext);
	  int maxx = ext[1]-ext[0]+1;
	  int maxy = ext[3]-ext[2]+1;
	  int maxz = ext[5]-ext[4]+1;
	  if ( x<0 ) {  printf("Warnnig bbtk::vtk::SegmentationConnectivity::DoProcess limites of the image out of range x: %d -> 0 \n",x ); x=0; }
	  if ( y<0 ) {  printf("Warnnig bbtk::vtk::SegmentationConnectivity::DoProcess limites of the image out of range y: %d -> 0 \n",y ); y=0;}
	  if ( z<0 ) {  printf("Warnnig bbtk::vtk::SegmentationConnectivity::DoProcess limites of the image out of range z: %d -> 0 \n",z ); z=0;}

	  if ( x>=maxx ) {  printf("Warnnig bbtk::vtk::SegmentationConnectivity::DoProcess limites of the image out of range x: %d -> %d \n",x, maxx-1 ); x=maxx-1; }
	  if ( y>=maxy ) {  printf("Warnnig bbtk::vtk::SegmentationConnectivity::DoProcess limites of the image out of range y: %d -> %d \n",y, maxy-1 ); y=maxy-1; }
	  if ( z>=maxz ) {  printf("Warnnig bbtk::vtk::SegmentationConnectivity::DoProcess limites of the image out of range z: %d -> %d \n",y, maxz-1 ); z=maxz-1; }
	  
	  connect2->AddSeed( x,y,z );
	  connect2->Modified();
	  connect2->Update();
	  cast4->Update();			
	  bbSetOutputOut(cast4->GetOutput() );
  }
  
}// EO namespace bbvtk

#endif //_USE_VTK_





