/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "bbvtkSliceImage.h"
#include "bbvtkPackage.h"
namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,SliceImage)
BBTK_BLACK_BOX_IMPLEMENTATION(SliceImage,bbtk::AtomicBlackBox);
void SliceImage::Process()
{
	vtkImageData* original = bbGetInputIn();

	if (original == NULL)
	{
		std::cout << "Set In" << std::endl;
		return;
	}

	//if (lastId == bbGetInputZ())
	//	return;

	int z = bbGetInputZ();
	int max_z;

	int ext[6];
	int newDim[3];
	double space[3];
	double origin[3];

	original->GetSpacing(space);
	original->GetExtent(ext);
	original->GetOrigin(origin);
	original->GetDimensions(newDim);
	max_z = newDim[2];
	newDim[2] = 1;

	int scalar_type = original->GetScalarType();

	if (final == NULL)
	{
		final = vtkImageData::New();
		final->SetSpacing(space);
		final->SetDimensions(newDim);
		final->SetScalarType(scalar_type);
		final->AllocateScalars();
		final->Update();


	}

	bbSetOutputMax(max_z);

	if (z>=max_z)
	{
		z = max_z-1;
	}

	for (int i=0; i<newDim[0]; i++){
		for (int j=0; j<newDim[1]; j++){
			switch (scalar_type)
			{
				case VTK_CHAR:
					char * ap2;
					ap2 = (char *) final->GetScalarPointer(i,j,0);
					*ap2 = *((char*) (original->GetScalarPointer(i,j,z)));
				break;
				case VTK_UNSIGNED_CHAR:
					unsigned char * ap3;
					ap3 = (unsigned char *) final->GetScalarPointer(i,j,0);
					*ap3 = *((unsigned char *)(original->GetScalarPointer(i,j,z)));
				break;
				case VTK_SHORT:
					short * ap4;
					ap4 = (short *) final->GetScalarPointer(i,j,0);
					*ap4 = *((short *)(original->GetScalarPointer(i,j,z)));
				break;
				case VTK_UNSIGNED_SHORT:
					unsigned short * ap5;
					ap5 = (unsigned short *) final->GetScalarPointer(i,j,0);
					*ap5 = *((unsigned short *)(original->GetScalarPointer(i,j,z)));
				break;
				case VTK_INT:
					int * ap6;
					ap6 = (int *) final->GetScalarPointer(i,j,0);
					*ap6 = *((int *)(original->GetScalarPointer(i,j,z)));
				break;
				case VTK_UNSIGNED_INT:
					unsigned int * ap7;
					ap7 = (unsigned int *) final->GetScalarPointer(i,j,0);
					*ap7 = *((unsigned int *)(original->GetScalarPointer(i,j,z)));
				break;
				case VTK_LONG:
					long * ap8;
					ap8 = (long *) final->GetScalarPointer(i,j,0);
					*ap8 = *((long *)(original->GetScalarPointer(i,j,z)));
				break;
				case VTK_UNSIGNED_LONG:
					unsigned long * ap9;
					ap9 = (unsigned long *) final->GetScalarPointer(i,j,0);
					*ap9 = *((unsigned long *)(original->GetScalarPointer(i,j,z)));
				break;
				case VTK_FLOAT:
					float * ap10;
					ap10 = (float *) final->GetScalarPointer(i,j,0);
					*ap10 = *((float *)(original->GetScalarPointer(i,j,z)));
				break;
				case VTK_DOUBLE:
					double * ap11;
					ap11 = (double *) final->GetScalarPointer(i,j,0);
					*ap11 = *((double *)(original->GetScalarPointer(i,j,z)));
				break;
			}
		}
	}

	caster = vtkImageCast::New();
	caster->SetInput(final);
	caster->SetOutputScalarTypeToShort();
	caster->Update();

	bbSetOutputOut(caster->GetOutput());

	std::cout << "updated slice " << z << std::endl;
	bbSignalOutputModification();
	lastId = bbGetInputZ();
}
void SliceImage::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX
//    Here we initialize the input 'In' to 0
   bbSetInputIn(NULL);
   bbSetOutputOut(NULL);
   final = NULL;

}
void SliceImage::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should allocate the internal/output pointers
//    if any


}
void SliceImage::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing
//    but this is where you should desallocate the internal/output pointers
//    if any

}
}
// EO namespace bbvtk


