/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "bbvtkSphereList.h"
#include "bbvtkPackage.h"

#include <vtkPolyDataMapper.h>
#include <vtkProperty.h>
#include <vtkRenderWindow.h>

namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,SphereList)
BBTK_BLACK_BOX_IMPLEMENTATION(SphereList,bbtk::AtomicBlackBox);

double SphereList::GetRadio(int i)
{
    double radio;
	if ( bbGetInputlstRadio().size()==0 )
        {
            radio = 1.0;
        } else if ( i<bbGetInputlstRadio().size() )
	{
            radio = bbGetInputlstRadio()[i];
        } else  
        {
            radio = bbGetInputlstRadio()[ bbGetInputlstRadio().size() - 1 ];
        }  

       return radio;
}


void SphereList::GetPoint(int i, double &px,double &py,double &pz)        
 {
      double spc[3];
      if (bbGetInputSpacing().size()==3)
      {
		spc[0]=bbGetInputSpacing()[0];
		spc[1]=bbGetInputSpacing()[1];
		spc[2]=bbGetInputSpacing()[2];
      } else {
	        spc[0]=spc[1]=spc[2]=1;
       }

       px = bbGetInputlstPointX()[i]*spc[0];
       if (bbGetInputlstPointY().size() == bbGetInputlstPointX().size() )
       {
		py = bbGetInputlstPointY()[i]*spc[1];
	}
		if (bbGetInputlstPointZ().size() == bbGetInputlstPointX().size() )
	{			
		pz = bbGetInputlstPointZ()[i]*spc[2];
	}
}  

			
void SphereList::GetColor(int i, double &cr,double &cg,double &cb)        
 {
	unsigned int j = 3*i +2;
	if (j < bbGetInputColour().size() )
	{
		cr=bbGetInputColour()[3*i+0];
		cg=bbGetInputColour()[3*i+1];
		cb=bbGetInputColour()[3*i+2];
		
	} else {
		int lastValidColorIndex = (bbGetInputColour().size()-1)/3;
		lastValidColorIndex	= lastValidColorIndex*3;
		cr=bbGetInputColour()[ lastValidColorIndex+0 ];
		cg=bbGetInputColour()[ lastValidColorIndex+1 ];
		cb=bbGetInputColour()[ lastValidColorIndex+2 ];
	}
}  



void SphereList::Process()
{

        int iMin, iMax;
	double px = 0.0;
	double py = 0.0;
	double pz = 0.0;

	double cr = 0.0;
	double cg = 0.0;
	double cb = 0.0;
	
	if (bbGetInputRenderer()!=NULL)
	{
                // If it is not the first time Process is executed, the actors have already been created. The only thing to do is to update the opacity. 
		if (sphereActor.size() != 0)
                {
                  for (int i = 0; i < sphereActor.size(); i++)
                  {
			GetPoint(i, px,py,pz);
			GetColor(i, cr,cg,cb);
			sphereActor[i] ->SetPosition( px,py,pz );
                      	sphereActor[i] -> GetProperty() -> SetOpacity( bbGetInputOpacity() );
                      	sphereActor[i] -> GetProperty() -> SetColor( cr,cg,cb );
                      	vtkspheresourceLst[i] -> SetRadius( GetRadio(i) ); 
	          } // for i
	        } else {
                   

                    iMin=0;
                    iMax=bbGetInputlstPointX().size();
//                    printf("EED SphereList::Process   iMax=%d \n", iMax);
//                    for (int i = 0; i < iMax; i++)
//                      {
//                        std::cout << "CM SphereList::Process i=" <<  i  << " bbGetInputlstPointX()[i]=" << bbGetInputlstPointX()[i] << std::endl;
//                        std::cout << "CM SphereList::Process i=" <<  i  << " bbGetInputlstPointY()[i]=" << bbGetInputlstPointY()[i] << std::endl;
//                        std::cout << "CM SphereList::Process i=" <<  i  << " bbGetInputlstPointZ()[i]=" << bbGetInputlstPointZ()[i] << std::endl;
//                      } // for i
 
                   // If the vector Y or respectively the vector Z has a different size from the vector X, the position value py or respectively pz is set to 0.
                    for ( int i=iMin ; i<iMax; i=i+1 )
                    {
                         

                        GetPoint(i, px,py,pz);
			GetColor(i, cr,cg,cb);
			

			// Sphere
			vtkSphereSource * newSphere =  vtkSphereSource::New();
			vtkspheresourceLst.push_back(newSphere);

			newSphere -> SetThetaResolution(20);
			newSphere -> SetPhiResolution(20);
			newSphere -> SetRadius( GetRadio(i) ); 

			vtkPolyDataMapper * newMapper = vtkPolyDataMapper::New();
			newMapper -> SetInput( newSphere -> GetOutput() );
	
			vtkActor * newActor = vtkActor::New();
			sphereActor.push_back(newActor);
			newActor -> SetMapper(newMapper);
			newActor -> SetOrigin(0, 0, 0);			
			newActor -> GetProperty() -> SetColor(cr,cg,cb);
			newActor -> GetProperty() -> SetOpacity( bbGetInputOpacity() );
			newActor -> SetPosition( px,py,pz );
	
			if ( bbGetInputTransform()!=NULL )
			{
				newActor->SetUserTransform( bbGetInputTransform() );
			}
	

			if (bbGetInputRenderer()!=NULL)
			{
			    bbGetInputRenderer() -> AddActor( newActor );
			}

                    } // for

                    if (sphereActor.size() != 0)
                    {
                        // Sets the output.
                        bbSetOutputActorList(sphereActor);
                    }
                    
                } // if (bbGetInputRenderer()!=NULL)

        } // if (sphereActor.size() != 0)
}

void SphereList::bbUserSetDefaultValues()
{
 
  bbSetInputRenderer(NULL);
  bbSetInputTransform(NULL);
 
  // Sets default radio to 1.
  std::vector<double> radio;
  radio.push_back(1.0);
  bbSetInputlstRadio(radio);

  // Sets default colour to red.
  std::vector<double> colour;
  colour.push_back(1.0);
  colour.push_back(0.0);
  colour.push_back(0.0);
  bbSetInputColour(colour);
	
	// Sets default spacing.
	std::vector<double> spacing;
	spacing.push_back(1.0);
	spacing.push_back(1.0);
	spacing.push_back(1.0);
	bbSetInputSpacing(spacing);
	
  bbSetInputOpacity(1.0);

}

void SphereList::bbUserInitializeProcessing()
{
 
}

void SphereList::bbUserFinalizeProcessing()
{
  
}
}
// EO namespace bbvtk


