//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbvtkSurfaceTexture.h"
#include "bbvtkPackage.h"

#include <vtkPointData.h>


namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,SurfaceTexture)
BBTK_BLACK_BOX_IMPLEMENTATION(SurfaceTexture,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void SurfaceTexture::Process()
{

// THE MAIN PROCESSING METHOD BODY
//   Here we simply set the input 'In' value to the output 'Out'
//   And print out the output value
// INPUT/OUTPUT ACCESSORS ARE OF THE FORM :
//    void bbSet{Input|Output}NAME(const TYPE&)
//    const TYPE& bbGet{Input|Output}NAME() const 
//    Where :
//    * NAME is the name of the input/output
//      (the one provided in the attribute 'name' of the tag 'input')
//    * TYPE is the C++ type of the input/output
//      (the one provided in the attribute 'type' of the tag 'input')

//    bbSetOutputOut( bbGetInputIn() );
//    std::cout << "Output value = " <<bbGetOutputOut() << std::endl;
  
printf("EED SurfaceTexture::Process Start\n");

	int i;
	double spc[3];
	double range[2];
	int ext[6];
	bbGetInputImage()->GetSpacing(spc);
	bbGetInputImage()->GetScalarRange(range);
	bbGetInputImage()->GetWholeExtent(ext);
	int maxX = ext[1]-ext[0]+1;
	int maxY = ext[3]-ext[2]+1;
	int maxZ = ext[5]-ext[4]+1;
	
	if (firsttime==true)
	{
		firsttime=false;
		// Generate the colors for each point based on the color map
		colors = vtkUnsignedCharArray::New(); 
		colors->SetNumberOfComponents(3);
		colors->SetName("Colors");
		
		// Create the color map
		if (bbGetInputColorType()==1)
		{
			colorLookupTableWL = vtkWindowLevelLookupTable::New();
			colorLookupTable=colorLookupTableWL;
		} else {
			colorLookupTable = vtkLookupTable::New();
		}
  		colorLookupTable->SetTableRange(range[0],range[1]);
		colorLookupTable->Build();
		double rgba1[4];
		double rgba2[4];
		for (int iLookTable = 0; iLookTable<128; iLookTable++)
		{
		  colorLookupTable->GetTableValue(      iLookTable, rgba1);
		  colorLookupTable->GetTableValue(256-1-iLookTable, rgba2);

  		  colorLookupTable->SetTableValue(256-1-iLookTable , rgba1[0],rgba1[1],rgba1[2],rgba1[3]);
	  	  colorLookupTable->SetTableValue(      iLookTable , rgba2[0],rgba2[1],rgba2[2],rgba2[3]);
		} // for iLookTable

	}

	bbGetInputMesh()->GetPointData()->SetScalars(colors);

	if (bbGetInputColorType()==1)
	{
		colorLookupTableWL->SetLevel( bbGetInputColorLevel() );
		colorLookupTableWL->SetWindow( bbGetInputColorWindow() );
	}	
		
    int missingpoints = bbGetInputMesh()->GetNumberOfPoints() - colors->GetDataSize()/colors->GetNumberOfComponents();
	for(i = 0; i < missingpoints; i++)
    {
		colors->InsertNextTuple3(0,0,0);
	}	

	if (bbGetInputTransform()!=NULL)
	{
		bbGetInputTransform()->Update();
	}
	
	double gl; 
	double p1[3];
	double p2[3];
	double dcolor[3];
	for(i = 0; i < bbGetInputMesh()->GetNumberOfPoints(); i++)
    {
		if (bbGetInputTransform()!=NULL)
		{
			bbGetInputMesh()->GetPoint(i,p1);
			bbGetInputTransform()->TransformPoint(p1,p2);
		} else {
			bbGetInputMesh()->GetPoint(i,p2);
		}
		p2[0] = p2[0]/spc[0];
		p2[1] = p2[1]/spc[1];
		p2[2] = p2[2]/spc[2];	
		
		if ( (p2[0]>=0) && (p2[0]<maxX) && (p2[1]>=0) && (p2[1]<maxY) &&(p2[2]>=0) && (p2[2]<maxZ)  )
		{
		   gl =  bbGetInputImage()->GetScalarComponentAsDouble(p2[0], p2[1], p2[2],0);
		} else {
			gl=0;
		}
		colorLookupTable->GetColor(gl, dcolor);
		colors->SetTuple3(i,255*dcolor[0],255*dcolor[1],255*dcolor[2]);		
	} // for i
	bbGetInputMesh()->Modified();	

}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void SurfaceTexture::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
//    Here we initialize the input 'In' to 0
 	bbSetInputMesh(NULL);
	bbSetInputImage(NULL);
	bbSetInputColorType(0);
	bbSetInputColorLevel(500);
	bbSetInputColorWindow(500);
	bbSetInputTransform(NULL);
  
	firsttime				= true;
	colors					= NULL;
	colorLookupTable		= NULL;
	colorLookupTableWL	= NULL;
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void SurfaceTexture::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 

  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void SurfaceTexture::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any
  
}
}
// EO namespace bbvtk


