/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//=====
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbvtkTemporalPicker.h"
#include "bbvtkPackage.h"
namespace bbvtk
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,TemporalPicker)
BBTK_BLACK_BOX_IMPLEMENTATION(TemporalPicker,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void TemporalPicker::Process()
{

// THE MAIN PROCESSING METHOD BODY
//   Here we simply set the input 'In' value to the output 'Out'
//   And print out the output value
// INPUT/OUTPUT ACCESSORS ARE OF THE FORM :
//    void bbSet{Input|Output}NAME(const TYPE&)
//    const TYPE& bbGet{Input|Output}NAME() const 
//    Where :
//    * NAME is the name of the input/output
//      (the one provided in the attribute 'name' of the tag 'input')
//    * TYPE is the C++ type of the input/output
//      (the one provided in the attribute 'type' of the tag 'input')

	
	std::vector<double> result;
	if (bbGetInputIn()!=NULL)
	{
		int ext[6];
		int sizeX,sizeY,sizeZ;
		bbGetInputIn()->GetWholeExtent(ext);
		sizeX=ext[1]-ext[0]+1;
		sizeY=ext[3]-ext[2]+1;
		sizeZ=ext[5]-ext[4]+1;
		
		if (bbGetInputPoint().size()>=2)
		{
			int px=bbGetInputPoint()[0];
			int py=bbGetInputPoint()[1];
			int pz=bbGetInputPoint()[2];
			
			if ((px>=0) && (px<sizeX)  && (py>=0) && (py<sizeY) )
			{
				int i,j,k;
				int minX,maxX,minY,maxY;
				int acum,numElem;
				minX=px-bbGetInputSizeRegion()-1;
				maxX=px+bbGetInputSizeRegion()-1;
				minY=py-bbGetInputSizeRegion()-1;
				maxY=py+bbGetInputSizeRegion()-1;
				for (k=0;k<sizeZ;k++)
				{
					acum=0;
					numElem=0;
					for(i=minX;i<=maxX;i++)
					{ 
						for(j=minY;j<=maxY;j++)
						{ 
							if ((i>=0) && (i<sizeX)  && (j>=0) && (j<sizeY) )
							{ 
								acum = acum + bbGetInputIn()->GetScalarComponentAsDouble(i, j, k, 0);
								numElem++;
							}// i j
						}// for j
					} // for i
					
					if (numElem>0) 
					{
						result.push_back( acum/numElem );
					} else {
						result.push_back( 0 );
					} // numElem
					
				} // for k
			} // px py
		} else {// bbGetInputPoint
			printf("ERROR:  Input:Point is not good defined in TemporalPicker Box..\n ");
		} // bbGetInputPoint
	} else {// bbGetInputIn
		printf("ERROR:  Missing Input:In vtkImageData* in TemporalPicker Box..\n ");
	} // bbGetInputIn

	bbSetOutputOut(result);
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void TemporalPicker::bbUserSetDefaultValues()
{

//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX 
//    Here we initialize the input 'In' to 0
	bbSetInputIn(NULL);
	bbSetInputSizeRegion(1);
  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void TemporalPicker::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 

  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void TemporalPicker::bbUserFinalizeProcessing()
{

//  THE FINALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should desallocate the internal/output pointers 
//    if any
  
}
}
// EO namespace bbvtk


