/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#include "bbvtkTransform.h"
#include "bbvtkPackage.h"
namespace bbvtk
{
  BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,Transform);
  BBTK_BLACK_BOX_IMPLEMENTATION(Transform,bbtk::AtomicBlackBox);

  	// --------------------------------------------------------------	

	void Transform::bbUserSetDefaultValues()
	{
		bbSetInputIn(NULL);

		vecScale.push_back(1);  // scale x
		vecScale.push_back(1);  // scale y
		vecScale.push_back(1);  // scale z
		bbSetInputScale(vecScale);

		vecRotateWXYZ.push_back(0);  //angle 
		vecRotateWXYZ.push_back(1);  //vx
		vecRotateWXYZ.push_back(0);  //vy
		vecRotateWXYZ.push_back(0);  //vz
		bbSetInputRotateWXYZ(vecRotateWXYZ);

		vecTranslate.push_back(0);  //tx
		vecTranslate.push_back(0);  //ty
		vecTranslate.push_back(0);  //tz
		bbSetInputTranslate(vecTranslate);

		vecSpacing.push_back(1);  //spacing x
		vecSpacing.push_back(1);  //spacing y
		vecSpacing.push_back(1);  //spacing z
		bbSetInputSpacing(vecSpacing);

		result = NULL;  
	}

	// --------------------------------------------------------------	
	void Transform::bbUserInitializeProcessing()
	{
		bbUserFinalizeProcessing();
		result = vtkTransform::New();
	}

	// --------------------------------------------------------------	
	void Transform::bbUserFinalizeProcessing()
	{
		if (result!=NULL)
		{
			result->Delete();
			result=NULL;
		}
	}

  	// --------------------------------------------------------------	
  void Transform::Process()
  {
	  bbUserInitializeProcessing();
	  if (bbGetInputIn()!=NULL)
      {
		  result->Concatenate( bbGetInputIn()->GetMatrix() );
      }

	  if (bbGetInputScale().size()>=3)
      {
		  result->Scale(bbGetInputScale()[0], bbGetInputScale()[1], bbGetInputScale()[2]);
      }
 
	  if ((bbGetInputTranslate().size()>=3) && (bbGetInputSpacing().size()>=3))
      {
		  double tx = bbGetInputTranslate()[0] * bbGetInputSpacing()[0];
		  double ty = bbGetInputTranslate()[1] * bbGetInputSpacing()[1];
		  double tz = bbGetInputTranslate()[2] * bbGetInputSpacing()[2];
		  result->Translate(tx,ty,tz);
      }

	  if (bbGetInputRotateWXYZ().size()>=4)
      {
		  result->RotateWXYZ(bbGetInputRotateWXYZ()[0],bbGetInputRotateWXYZ()[1], bbGetInputRotateWXYZ()[2], bbGetInputRotateWXYZ()[3]);
      }

	  result->Update();
 
	  bbSetOutputOut(result);
  }
}
// EO namespace bbvtk
