/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbvtkUnMosaic.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:51:58 $
  Version:   $Revision: 1.4 $
=========================================================================*/

/**
 *  \file 
 *  \brief 
 */

#ifdef _USE_VTK_
#include "bbvtkUnMosaic.h"
#include "bbvtkPackage.h"

namespace bbvtk
{
   BBTK_ADD_BLACK_BOX_TO_PACKAGE(vtk,UnMosaic)
   BBTK_BLACK_BOX_IMPLEMENTATION(UnMosaic,bbtk::AtomicBlackBox);

//---------------------------------------------------------------------

   void UnMosaic::bbUserSetDefaultValues() 
   { 
      //std::cout << "-------- entree ds UnMosaic::bbUserSetDefaultValues()\n" << std::endl;
      
   // bbSetInputIn(NULL);  /// \TODO fix it! IN is a std::vector<vtkImageData> // JPR
      mImageOut = NULL;
      bbSetOutputOut(NULL);
   }

//---------------------------------------------------------------------

   void UnMosaic::bbUserInitializeProcessing() 
   {
       //std::cout << "-------- entree ds UnMosaic::bbUserInitalizeProcessing()\n" << std::endl;
      //bbUserFinalizeProcessing();
      mImageOut = vtkImageData::New();  // Alloc depends on  bbGetInputIn().size()  
   }
  
//---------------------------------------------------------------------

   void UnMosaic::bbUserFinalizeProcessing() 
   {
            //std::cout << "-------- entree ds UnMosaic::bbUserFinalizeProcessing()\n" << std::endl;
   // WTF? we never enter here // JPR  bbUserFinalizeProcessing()  JPR	
      if (mImageOut!=NULL)
      {
        // mImageOut->Delete();
        // mImageOut=NULL;
      }
      bbSetOutputOut(mImageOut);          
   }

//---------------------------------------------------------------------
 
 ///  :
 ///  - receives a vtkImageData*imageIn, int nbImagesPerRow, int numberOfImagesInMosaic 
 ///  - exports a vtkImageData* as a3D image
 ///  - supposes the input image is a 2D Siemens Mosaic
 ///
   void UnMosaic::Process()
   {
	int nbImagesPerRow =   (unsigned int)bbGetInputNbImagesPerRow();
	int nbImagesInMosaic = (unsigned int)bbGetInputNbImagesInMosaic();	

        if (nbImagesPerRow == 0 || nbImagesInMosaic == 0) {
	   std::cout << "Go away!" << std::endl; // ??? JPR
	   // exit(0);
	}
	
	vtkImageData* imageIn = bbGetInputIn();
	
	vtkImageData * mImageOut = unMosaic(imageIn, nbImagesPerRow, nbImagesInMosaic);
      
   // Devrait etre dans bbUserFinalizeProcessing() ? // JPR	
        bbSetOutputOut(mImageOut);   	
   }


vtkImageData * UnMosaic::unMosaic(vtkImageData *imageIn, int nbImagesPerRow, int numberOfImagesInMosaic)
{   
   int inputdims[3];
   int outputdims[3];
   imageIn->GetDimensions (inputdims);
   unsigned short *input = (unsigned short *)(imageIn->GetScalarPointer());
   imageIn->Update();
     
   unsigned int div = (unsigned int)ceil(sqrt( (double)numberOfImagesInMosaic ) );
   outputdims[0] = inputdims[0] / div;
   outputdims[1] = inputdims[1] / div;
   outputdims[2] = numberOfImagesInMosaic;
 
    vtkImageData *vtkImageOut;
    vtkImageOut = vtkImageData::New();
    vtkImageOut->SetDimensions( outputdims );
    vtkImageOut->SetExtent(0,outputdims[0]-1,0,outputdims[1]-1,0,outputdims[2]-1);
    vtkImageOut->SetWholeExtent(0,outputdims[0]-1,0,outputdims[1]-1,0,outputdims[2]-1);
    vtkImageOut->SetNumberOfScalarComponents(1);
//vtkImageOut->SetSpacing( blabla );
    vtkImageOut->SetScalarType( VTK_UNSIGNED_SHORT );
    vtkImageOut->AllocateScalars();
    vtkImageOut->Update();
    
    unsigned short *output =(unsigned short *)(vtkImageOut->GetScalarPointer());

    unsigned short *dest = output;
    int dimXImageElem = outputdims[0];
    int dimYImageElem = outputdims[1];
    int lgrImage = dimXImageElem*dimYImageElem;
    int debImage;
    for (int i=0; i<numberOfImagesInMosaic; i++)
    {
       debImage=(i/nbImagesPerRow) * lgrImage*nbImagesPerRow + (i%nbImagesPerRow)*dimXImageElem;
       for(int j=0; j<dimYImageElem; j++)
       {
          memcpy(dest, input+debImage, dimXImageElem*sizeof(unsigned short));
          debImage += dimXImageElem*nbImagesPerRow;
          dest += dimXImageElem;
       }
    }
    return  vtkImageOut;    
}

}//namespace bbtk

#endif // _USE_VTK_
